/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.app.server;

import com.iosoft.helpers.Stopwatch;
import com.iosoft.ioengine.app.AppProtocol;
import com.iosoft.ioengine.app.server.AppData;
import com.iosoft.ioengine.app.server.Client;
import com.iosoft.ioengine.app.server.DedicatedInfo;
import com.iosoft.ioengine.base.NetworkActor;
import com.iosoft.ioengine.base.server.BaseClient;
import com.iosoft.ioengine.base.server.BaseServerApp;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;

public abstract class ServerApp<D extends AppData<? extends ServerApp<D, C>>, C extends Client<? extends ServerApp<D, C>, D>>
extends BaseServerApp<C> {
    private final Map<String, Integer> clientDisconnectByReason = new HashMap<String, Integer>();
    protected D data;

    public ServerApp() {
        this.fillClientDisconnectByReasonMapping(this.clientDisconnectByReason);
    }

    @Override
    protected void serverInit() {
        this.data = this.createAppData();
        ((AppData)this.data).initCreated((ServerApp)this);
    }

    @Override
    protected void onServerStarted() {
        super.onServerStarted();
        ((AppData)this.data).onServerStarted();
    }

    protected void fillClientDisconnectByReasonMapping(Map<String, Integer> mapping) {
        mapping.put("Kicked", 1);
        mapping.put("Banned", 2);
        mapping.put("Version", 3);
        mapping.put("Full", 4);
        mapping.put("Serverstop", 7);
    }

    protected Integer getProtocolDisconnectReason(Object reasonID) {
        return this.clientDisconnectByReason.get(reasonID);
    }

    public abstract AppProtocol getProtocol();

    protected abstract D createAppData();

    public D getData() {
        return this.data;
    }

    public DedicatedInfo getDedicatedInfo() {
        if (!this.running) {
            return null;
        }
        DedicatedInfo dediInfo = this.createDedicatedServerInfo();
        this.fillDediInfo(dediInfo);
        return dediInfo;
    }

    protected DedicatedInfo createDedicatedServerInfo() {
        return new DedicatedInfo();
    }

    protected void fillDediInfo(DedicatedInfo info) {
        info.serverName = this.serverName;
        info.time_running = Stopwatch.getDuration(this.sw_start);
        info.maxClients = this.getMaxClients();
        info.noNetwork = this.networkFailed;
        info.connectedClients = 0;
        info.clients = new DedicatedInfo.ClientSlot[this._clients.size()];
        for (Client client : this._clients) {
            DedicatedInfo.ClientSlot slot;
            if (!client.isConnected()) continue;
            ++info.connectedClients;
            info.clients[client.getSlotId()] = slot = info.makeClientSlot();
            this.insertClientSlotDediInfo(info, client, slot);
        }
    }

    protected void insertClientSlotDediInfo(DedicatedInfo info, C client, DedicatedInfo.ClientSlot slot) {
        InetAddress addr = ((BaseClient)client).tryGetIPAddr();
        slot.ip = addr == null ? "local" : addr.toString();
        slot.name = ((BaseClient)client).getName();
        slot.greeted = ((NetworkActor)client).isFullyConnected();
        slot.ping = ((BaseClient)client).getPing();
    }
}

