/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.app.client;

import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.network.IpPort;
import com.iosoft.ioengine.app.client.AppState;
import com.iosoft.ioengine.base.client.BaseClientApp;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;

public abstract class ClientApp<S extends AppState<? extends ClientApp<S>>>
extends BaseClientApp {
    private S appState;
    private Map<Integer, String> serverDisconnectReasonMapping = new HashMap<Integer, String>();

    public ClientApp() {
        this.fillServerDisconnectReasonMapping(this.serverDisconnectReasonMapping);
    }

    @Override
    public void initialize() {
        this.appState = this.createAppState();
        super.initialize();
    }

    protected void fillServerDisconnectReasonMapping(Map<Integer, String> mapping) {
        mapping.put(1, "Kicked");
        mapping.put(2, "Banned");
        mapping.put(3, "Version");
        mapping.put(4, "Full");
        mapping.put(5, "NetworkFail");
        mapping.put(7, "Serverstop");
    }

    public String getReasonByDisconnectMessage(int reasonID) {
        String reason = this.serverDisconnectReasonMapping.get(reasonID);
        return reason == null ? "UnknownServerReason" : reason;
    }

    @Override
    protected void reset() {
        super.reset();
        ((AppState)this.appState).reset();
    }

    @Override
    protected void onResolving(IpPort target) {
        ((AppState)this.appState).onResolving(target);
    }

    @Override
    protected void onConnecting(SocketAddress ip) {
        ((AppState)this.appState).onConnecting(ip);
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        ((AppState)this.appState).onConnected();
        this.send_msgGreeting();
    }

    @Override
    protected void onDisconnecting(TextWithArguments reason) {
        ((AppState)this.appState).onDisconnected(reason);
        super.onDisconnecting(reason);
    }

    @Override
    protected void init() {
        ((AppState)this.appState).setClientApp((ClientApp)this);
        super.init();
    }

    @Override
    public void onImportantLoaded() {
        ((AppState)this.appState).onImportantLoaded();
        super.onImportantLoaded();
    }

    public void onLoaded() {
        ((AppState)this.appState).onLoaded();
    }

    @Override
    protected void onTick(long swNow) {
        ((AppState)this.appState).tick();
        super.onTick(swNow);
    }

    protected abstract S createAppState();

    public S getAppState() {
        return this.appState;
    }

    @Override
    protected void onGreetingReceived() {
        super.onGreetingReceived();
    }

    protected void onPingRequest() {
        this.setTimeout(this.getTimeoutMessagesSeconds());
    }

    @Override
    protected void sendQuitMessage() {
        this.send_msgQuit();
    }

    protected abstract void send_msgQuit();

    protected abstract void send_msgGreeting();
}

