/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.app.client;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.network.IpPort;
import com.iosoft.ioengine.AppProtocolException;
import com.iosoft.ioengine.app.client.ClientApp;
import com.iosoft.ioengine.base.IMessage;
import com.iosoft.ioengine.base.NetworkActor;
import com.iosoft.ioengine.game.client.IBlockEndingMessage;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;

public abstract class AppState<C extends ClientApp<? extends AppState<C>>> {
    protected SocketAddress serverAddress;
    protected String serverVersion;
    protected String serverName;
    protected boolean serverLocal;
    protected boolean connected;
    protected boolean fullyConnected;
    private boolean connecting;
    protected C client;
    public static final String STEP_STARTING = "Starting";
    public static final String STEP_RESOLVING = "Resolving";
    public static final String STEP_CONNECTING = "Connecting";
    public static final String STEP_WAITFORGREETING = "Waiting";
    public static final String STEP_DATA = "Data";

    protected void setClientApp(C clientApp) {
        this.client = clientApp;
    }

    public abstract void onImportantLoaded();

    public abstract void onLoaded();

    public C getClientApp() {
        return this.client;
    }

    public void reset() {
        this.serverLocal = false;
        this.serverName = "";
        this.serverVersion = "?";
        this.serverAddress = null;
        this.connected = false;
        this.fullyConnected = false;
        this.connecting = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isFullyConnected() {
        return ((NetworkActor)this.client).isFullyConnected() && this.fullyConnected;
    }

    public boolean wasFullyConnected() {
        return this.fullyConnected;
    }

    protected abstract void tick();

    protected void onConnectingStarts() {
        this.onConnectionStep(STEP_STARTING);
    }

    private void startConnecting(boolean local, String target) {
        this.serverLocal = local;
        if (target != null || !this.connecting) {
            this.setConnectTarget(target);
        }
        if (!this.connecting) {
            this.connecting = true;
            this.onConnectingStarts();
        }
    }

    protected abstract void setConnectTarget(String var1);

    protected void onResolving(IpPort target) {
        this.startConnecting(false, target.toString());
        this.onConnectionStep(STEP_RESOLVING);
    }

    protected void onConnecting(SocketAddress address) {
        String target;
        Misc.notNull(address);
        this.serverAddress = address;
        if (address instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)address;
            target = new IpPort(isa.getHostString(), (char)isa.getPort()).toString();
        } else {
            target = address.toString();
        }
        this.startConnecting(false, target);
        this.onConnectionStep(STEP_CONNECTING);
    }

    protected void onConnected() {
        this.startConnecting(this.serverAddress == null, null);
        this.connected = true;
        this.onConnectionStep(STEP_WAITFORGREETING);
    }

    protected void onGreetingStarts() {
        this.onConnectionStep(STEP_DATA);
    }

    protected abstract void onConnectionStep(String var1);

    protected abstract void onFullyConnected();

    protected void onDisconnected(TextWithArguments reason) {
        this.connected = false;
        this.fullyConnected = false;
    }

    public VersionMessage msgx_setVersion(String sVersion) {
        return new VersionMessage(sVersion);
    }

    public boolean isServerLocal() {
        return this.serverLocal;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public SocketAddress getServerAddress() {
        return this.serverAddress;
    }

    protected class DisconnectMessage
    implements IBlockEndingMessage {
        protected TextWithArguments reason;

        public DisconnectMessage(TextWithArguments reason) {
            this.reason = reason;
        }

        @Override
        public void run() {
            ((NetworkActor)AppState.this.client).disconnect(this.reason);
        }

        @Override
        public boolean doImmediatelyMustStartBlock() throws AppProtocolException {
            return true;
        }
    }

    protected class GreetingMessage
    extends MessageBlock {
        public GreetingMessage(List<IMessage> messages) {
            super(messages);
        }

        @Override
        public void run() throws AppProtocolException {
            ((ClientApp)AppState.this.client).onGreetingReceived();
            super.run();
            AppState.this.fullyConnected = true;
            AppState.this.onFullyConnected();
        }
    }

    protected class LinkedMessage
    implements IMessage {
        protected IMessage baseMsg;

        public LinkedMessage(IMessage baseMsg) {
            this.baseMsg = baseMsg;
        }

        @Override
        public void run() throws AppProtocolException {
            this.runBefore();
            if (((NetworkActor)AppState.this.client).isConnected()) {
                this.baseMsg.run();
            }
            this.runAfter();
        }

        public void runBefore() {
        }

        public void runAfter() {
        }
    }

    protected class MessageBlock
    implements IMessage {
        protected IMessage[] block;

        @SafeVarargs
        public MessageBlock(IMessage ... msgs) {
            this.block = msgs;
        }

        public MessageBlock(List<IMessage> msgs) {
            this.block = msgs.toArray(new IMessage[msgs.size()]);
        }

        @Override
        public void run() throws AppProtocolException {
            IMessage[] iMessageArray = this.block;
            int n = this.block.length;
            int n2 = 0;
            while (n2 < n) {
                IMessage m = iMessageArray[n2];
                if (((NetworkActor)AppState.this.client).isConnected()) {
                    m.run();
                }
                ++n2;
            }
        }
    }

    protected class VersionMessage
    implements IMessage {
        public String Version;

        public VersionMessage(String version) {
            this.Version = version;
        }

        @Override
        public void run() {
            AppState.this.serverVersion = this.Version;
        }
    }
}

