/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine.app;

import com.iosoft.helpers.Misc;
import com.iosoft.ioengine.game.IpAddressPair;

public abstract class AppProtocol {
    private final char defaultPort = this.makeDefaultPort();
    private final char[] lanPorts;
    private final IpAddressPair lanMulticastAddresses;

    public AppProtocol() {
        char[] extraLanPorts = this.makeExtraLANPorts();
        this.lanPorts = new char[2 + extraLanPorts.length];
        this.lanPorts[0] = this.defaultPort;
        this.lanPorts[1] = (char)(this.defaultPort + (this.defaultPort == '\uffff' ? -1 : 1));
        System.arraycopy(extraLanPorts, 0, this.lanPorts, 2, extraLanPorts.length);
        this.lanMulticastAddresses = Misc.notNull(this.makeLANMulticastIPs());
    }

    public char getDefaultPort() {
        return this.defaultPort;
    }

    public char[] getLANPorts() {
        return this.lanPorts;
    }

    public abstract String getMasterServerURL();

    public IpAddressPair getLANMulticastAddresses() {
        return this.lanMulticastAddresses;
    }

    protected char[] makeExtraLANPorts() {
        return new char[0];
    }

    protected abstract IpAddressPair makeLANMulticastIPs();

    protected abstract char makeDefaultPort();
}

