/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.io.BitDataInput;
import com.iosoft.helpers.io.BitDataOutput;
import com.iosoft.ioengine.AppProtocolException;
import com.iosoft.ioengine.Indexable;
import com.iosoft.ioengine.NetUtil;
import java.io.IOException;

public abstract class ValueList<T> {
    private final T[] _values;
    private final int _numBitsNotNull;
    private final int _numBitsNullable;

    public ValueList(T[] values) {
        this._values = values;
        this._numBitsNotNull = 32 - Integer.numberOfLeadingZeros(this._values.length);
        this._numBitsNullable = 32 - Integer.numberOfLeadingZeros(this._values.length + 1);
    }

    public T readNotNull(BitDataInput in) throws IOException {
        int index = in.readBits(this._numBitsNotNull);
        return NetUtil.ensureValue(this._values, index);
    }

    public T readNullable(BitDataInput in) throws IOException {
        int index = in.readBits(this._numBitsNullable);
        return Indexable.getFromIndexNullable(this._values, index);
    }

    public void writeNotNull(BitDataOutput out, T value) throws IOException {
        int index = this.getIndex(value);
        out.writeBits(index, this._numBitsNotNull);
    }

    public void writeNullable(BitDataOutput out, T value) throws IOException {
        int index = value == null ? 0 : this.getIndex(value) + 1;
        out.writeBits(index, this._numBitsNullable);
    }

    public T getNotNull(int index) throws AppProtocolException {
        if (index < 0 || index >= this._values.length) {
            throw new AppProtocolException("Unknown index '" + index + "' (" + this.getTypeName() + ")");
        }
        return this._values[index];
    }

    public T getNullable(int index) throws AppProtocolException {
        if (index < 0 || index > this._values.length) {
            throw new AppProtocolException("Unknown index '" + index + "' (" + this.getTypeName() + ")");
        }
        return index == 0 ? null : (T)this._values[index - 1];
    }

    protected String getTypeName() {
        Object value = MiscLINQ.firstOrDefault(this._values, x -> x != null);
        if (value == null) {
            return "?";
        }
        return Misc.getClassName(value);
    }

    protected abstract int getIndex(T var1);
}

