/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine;

import com.iosoft.ioengine.AppProtocolException;
import java.util.ArrayList;

public final class NetUtil {
    private NetUtil() {
    }

    public static int range(int num, int max) throws AppProtocolException {
        return NetUtil.range(num, 0, max);
    }

    public static int range(int num, int min, int max) throws AppProtocolException {
        if (num < min || num > max) {
            throw new AppProtocolException("Number " + num + " not in range " + min + " to " + max);
        }
        return num;
    }

    public static int rangeExclusive(int num, int max) throws AppProtocolException {
        return NetUtil.range(num, 0, max - 1);
    }

    public static <T> T ensureValue(T[] values, int index) throws AppProtocolException {
        return values[NetUtil.rangeExclusive(index, values.length)];
    }

    public static <T> T ensureValue(ArrayList<T> values, int index) throws AppProtocolException {
        return values.get(NetUtil.rangeExclusive(index, values.size()));
    }

    public static <T> void ensureValue(T mine, T servers, String name) throws AppProtocolException {
        if (!mine.equals(servers)) {
            throw new AppProtocolException(String.valueOf(name) + " does not match (client:\u00a0" + mine + "  server:\u00a0" + servers + ")");
        }
    }
}

