/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.ioengine;

import com.iosoft.helpers.io.BitDataInput;
import com.iosoft.helpers.io.BitDataOutput;
import com.iosoft.ioengine.AppProtocolException;
import com.iosoft.ioengine.NetUtil;
import java.io.IOException;

public final class NetList {
    private final int _count;
    private final int _numBitsNotNull;
    private final int _numBitsNullable;

    public NetList(int count) {
        this._count = count;
        this._numBitsNotNull = 32 - Integer.numberOfLeadingZeros(count);
        this._numBitsNullable = 32 - Integer.numberOfLeadingZeros(count + 1);
    }

    public int readNotNull(BitDataInput in) throws IOException {
        int index = in.readBits(this._numBitsNotNull);
        return NetUtil.rangeExclusive(index, this._count);
    }

    public int readNullable(BitDataInput in) throws IOException {
        int index = in.readBits(this._numBitsNullable) - 1;
        if (index == -1) {
            return -1;
        }
        return NetUtil.rangeExclusive(index - 1, this._count);
    }

    public void writeNotNull(BitDataOutput out, int value) throws IOException {
        out.writeBits(value, this._numBitsNotNull);
    }

    public void writeNullable(BitDataOutput out, int value) throws IOException {
        out.writeBits(value + 1, this._numBitsNullable);
    }

    public int isInRangeNotNull(int index) throws AppProtocolException {
        if (index < 0 || index >= this._count) {
            throw new AppProtocolException("Not in range '" + index + "'");
        }
        return index;
    }

    public int isInRangeNullable(int index) throws AppProtocolException {
        if (index < -1 || index >= this._count) {
            throw new AppProtocolException("Not in range '" + index + "'");
        }
        return index;
    }
}

