/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.web;

import java.io.IOException;

public abstract class WebResponse<T> {
    public final IOException Error;
    public final boolean TimedOut;
    public final int StatusCode;
    public final T Content;

    public WebResponse(IOException error, boolean timeouted, int statusCode, T content) {
        this.Error = error;
        this.TimedOut = timeouted;
        this.StatusCode = statusCode;
        this.Content = content;
    }

    public String toString() {
        return "[" + (this.Error == null ? "no error" : this.Error.toString()) + " | " + (this.TimedOut ? "timed out" : "no timeout") + " | " + this.StatusCode + " | " + this.getContentPreview() + "]";
    }

    protected abstract String getContentPreview();

    public void ensureSuccess() throws IOException {
        if (this.Error != null) {
            throw this.Error;
        }
        if (this.TimedOut) {
            throw new IOException("Request timed out");
        }
    }
}

