/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.web;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.web.AbstractResponseReader;
import com.iosoft.helpers.web.CancelWrapper;
import com.iosoft.helpers.web.StringResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class StringResponseReader
extends AbstractResponseReader<StringResponse> {
    private int _maxChars;
    private int _maxLines;
    private ArrayList<String> _actualLines;

    public StringResponseReader(int maxChars, int maxLines, boolean allowError) {
        super(allowError);
        this._maxChars = maxChars;
        this._maxLines = maxLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(URLConnection connection, CancelWrapper cancelWrapper) throws IOException {
        super.read(connection, cancelWrapper);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.openStream(connection), StandardCharsets.UTF_8));){
            CancelWrapper cancelWrapper2 = cancelWrapper;
            synchronized (cancelWrapper2) {
                block20: {
                    if (!cancelWrapper.Canceled) break block20;
                    return;
                }
                cancelWrapper.Disposable = () -> Misc.forceClose(reader);
            }
            this._actualLines = new ArrayList();
            while (this._maxChars != 0) {
                if (this._maxLines == 0) {
                    break;
                }
                if (this._maxLines > 0) {
                    --this._maxLines;
                }
                String line = reader.readLine();
                if (cancelWrapper.wasCanceledSync()) break;
                if (line == null) {
                    break;
                }
                if (this._maxChars >= 0) {
                    int len = line.length();
                    if (len > this._maxChars) {
                        line = line.substring(0, this._maxChars);
                    }
                    this._maxChars -= line.length();
                }
                this._actualLines.add(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public StringResponse returnResult(IOException error, boolean timedOut, boolean empty) {
        return new StringResponse(error, timedOut, empty ? -1 : this._statusCode, empty ? null : this._actualLines);
    }
}

