/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.web;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Mutable;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.web.MiscWeb;
import com.iosoft.helpers.web.StringResponse;

public final class ExternalIP {
    private static volatile int START_INDEX = 0;
    private static final String[] IP_APIS = new String[]{"https://api.ipify.org", "https://ipinfo.io/ip", "http://api.ipify.org"};
    private static final double SEC_TIMEOUT = 10.0;
    private static final int MAX_LENGTH = 100;

    private ExternalIP() {
    }

    private static String tryGetIP(StringResponse response) {
        String firstLine = response.tryGetFirstLine();
        if (firstLine != null && !(firstLine = firstLine.trim()).isEmpty()) {
            return firstLine;
        }
        return null;
    }

    private static String getFallback(boolean fallbackToLocal) {
        return fallbackToLocal ? Misc.getLocalInetAddress().getHostAddress() : null;
    }

    public static String get(boolean fallbackToLocal) throws InterruptedException {
        String url;
        Instance instance = new Instance();
        while ((url = instance.tryGetNextUrl()) != null) {
            String ip = ExternalIP.tryGetIP(MiscWeb.getFirstLine(url, 10.0, 100));
            Misc.checkInterrupted();
            if (ip == null) continue;
            return ip;
        }
        return ExternalIP.getFallback(fallbackToLocal);
    }

    public static Task<String> getAsync(boolean fallbackToLocal) {
        Mutable foundIp = new Mutable();
        Instance instance = new Instance();
        return Async.whileDo(() -> {
            if (mutable.Value != null) {
                return null;
            }
            String url = instance.tryGetNextUrl();
            if (url == null) {
                mutable.Value = ExternalIP.getFallback(fallbackToLocal);
                return null;
            }
            return MiscWeb.getFirstLineAsync(url, 10.0, 100).awaitAndContinue(response -> {
                String ip = ExternalIP.tryGetIP(response);
                if (ip != null) {
                    mutable.Value = ip;
                }
            });
        }).awaitAndContinue(() -> (String)mutable.Value);
    }

    static /* synthetic */ int access$0() {
        return START_INDEX;
    }

    private static class Instance {
        private final int _startIndex = ExternalIP.access$0();
        private int _currentIndex = -1;

        private Instance() {
        }

        private String tryGetNextUrl() {
            if (IP_APIS.length == 0) {
                return null;
            }
            if (this._currentIndex == -1) {
                this._currentIndex = this._startIndex;
            } else {
                ++this._currentIndex;
                if (this._currentIndex == IP_APIS.length) {
                    this._currentIndex = 0;
                }
                START_INDEX = this._currentIndex;
                if (this._startIndex == this._currentIndex) {
                    return null;
                }
            }
            return IP_APIS[this._currentIndex];
        }
    }
}

