/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.web;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.web.AbstractResponseReader;
import com.iosoft.helpers.web.BytesResponse;
import com.iosoft.helpers.web.CancelWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.function.DoubleConsumer;

public class BytesResponseReader
extends AbstractResponseReader<BytesResponse> {
    public int BufferSize = 0x100000;
    private final boolean _allowIncomplete;
    private final DoubleConsumer _progressUpdate;
    private final ByteArrayOutputStream _buffer = new ByteArrayOutputStream();
    private final OutputStream _outputTo;
    private boolean _isComplete;
    private int _maxSize;

    public BytesResponseReader(int maxSize, boolean allowIncomplete, boolean allowError, DoubleConsumer progressUpdate) {
        this(maxSize, allowIncomplete, allowError, progressUpdate, null);
    }

    public BytesResponseReader(int maxSize, boolean allowIncomplete, boolean allowError, DoubleConsumer progressUpdate, OutputStream outputTo) {
        super(allowError);
        this._maxSize = maxSize;
        this._allowIncomplete = allowIncomplete;
        this._progressUpdate = progressUpdate;
        this._outputTo = outputTo == null ? this._buffer : outputTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(URLConnection connection, CancelWrapper cancelWrapper) throws IOException {
        super.read(connection, cancelWrapper);
        long maxLength = connection.getContentLengthLong();
        if (this._maxSize >= 0 && maxLength > (long)this._maxSize) {
            maxLength = this._maxSize;
        }
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream in = this.openStream(connection);){
            CancelWrapper cancelWrapper2 = cancelWrapper;
            synchronized (cancelWrapper2) {
                block20: {
                    if (!cancelWrapper.Canceled) break block20;
                    return;
                }
                cancelWrapper.Disposable = () -> Misc.forceClose(in);
            }
            byte[] buffer = new byte[Math.max(1, this.BufferSize)];
            int readTotal = 0;
            int remainingBytes = this._maxSize;
            boolean hasLimit = this._maxSize >= 0;
            while (!cancelWrapper.wasCanceledSync()) {
                if (maxLength > 0L && this._progressUpdate != null) {
                    this._progressUpdate.accept(Misc.clamp01((double)readTotal / (double)maxLength));
                }
                if (hasLimit && remainingBytes <= 0) break;
                int read = in.read(buffer, 0, hasLimit ? Math.min(buffer.length, remainingBytes) : buffer.length);
                if (read < 0) {
                    this._isComplete = true;
                    break;
                }
                if (hasLimit) {
                    remainingBytes -= read;
                }
                readTotal += read;
                this._outputTo.write(buffer, 0, read);
            }
            if (!this._isComplete && hasLimit && remainingBytes <= 0) {
                this._isComplete = in.read() == -1;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public BytesResponse returnResult(IOException error, boolean timedOut, boolean empty) {
        byte[] content = null;
        if (!empty) {
            if (this._isComplete || this._allowIncomplete) {
                content = this._buffer.toByteArray();
            } else if (error == null) {
                error = new IOException("Response is incomplete");
            }
        }
        return new BytesResponse(error, timedOut, empty ? -1 : this._statusCode, content, !empty && this._isComplete);
    }
}

