/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import com.iosoft.helpers.BoolConsumer;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.binding.BoolBinding;
import com.iosoft.helpers.binding.Command;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.math.Misc2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.ListModel;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;

public final class MiscAWT {
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    public static final int TAKE_ALL_SPACE = 100000;
    private static final Object AA_TEXT_PROP = MiscAWT.getAaTextProperty();

    private MiscAWT() {
    }

    private static Object getAaTextProperty() {
        try {
            Class<?> c = Class.forName("sun.swing.SwingUtilities2");
            Field f = c.getField("AA_TEXT_PROPERTY_KEY");
            return f.get(null);
        }
        catch (Exception e) {
            Log.UI.errorFull("Cannot get hacky AA key, falling back to direct string", e);
            return "AATextInfoPropertyKey";
        }
    }

    public static void enableAA(JComponent c) {
        if (AA_TEXT_PROP != null) {
            c.putClientProperty(AA_TEXT_PROP, null);
        } else {
            Log.UI.warning("Cannot enable AA the hacky way for " + Misc.getClassName(c));
        }
    }

    public static void setSystemLookAndFeel() {
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setUIScale(double scale) {
        System.setProperty("sun.java2d.dpiaware", "false");
        System.setProperty("sun.java2d.uiScale", "" + scale);
    }

    public static void doDefaults(Component c, Component base) {
        Misc.notNull(c);
        Misc.notNull(base);
        c.setFont(base.getFont());
        c.setBackground(base.getBackground());
        c.setForeground(base.getForeground());
    }

    public static boolean repaintWindow(JComponent component) {
        Container tla = component.getTopLevelAncestor();
        if (tla != null) {
            tla.repaint();
            return true;
        }
        return false;
    }

    public static void scrollDownPane(JScrollPane scrollPane) {
        Misc.notNull(scrollPane);
        VTask.delay(0.05).await(() -> {
            Component content = scrollPane.getViewport().getView();
            if (content instanceof JComponent) {
                ((JComponent)content).scrollRectToVisible(new Rectangle(0, content.getHeight(), 1, 1));
            }
        });
    }

    public static void scrollDownContent(JComponent component) {
        Misc.notNull(component);
        VTask.delay(0.05).await(() -> component.scrollRectToVisible(new Rectangle(0, component.getHeight(), 1, 1)));
    }

    public static void setAA(Graphics2D g) {
        MiscAWT.setAA(g, true);
    }

    public static void setAA(Graphics2D g, boolean on) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, on ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static boolean hasAA(Graphics2D g) {
        return g.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    public static void setBestQuality(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    public static void drawCenteredString(String s, int offx, int offy, int w, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int x = offx + (w - fm.stringWidth(s)) / 2;
        int y = offy + (fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2);
        g.drawString(s, x, y);
    }

    public static void drawShadowedCenteredString(String s, int offx, int offy, int w, int h, Graphics g) {
        Color color = g.getColor();
        int alpha = color.getAlpha();
        MiscAWT.drawShadowedCenteredString(s, offx, offy, w, h, alpha == 255 ? Color.BLACK : new Color(0, 0, 0, alpha), g);
    }

    public static void drawShadowedCenteredString(String s, int offx, int offy, int w, int h, Color colShadow, Graphics g) {
        Color color = g.getColor();
        g.setColor(colShadow);
        FontMetrics fm = g.getFontMetrics();
        int x = offx + (w - fm.stringWidth(s)) / 2;
        int y = offy + (fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2);
        g.drawString(s, x + 1, y + 1);
        g.setColor(color);
        g.drawString(s, x, y);
    }

    public static void drawVerticalCenteredString(String s, int x, int offy, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int y = offy + (fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2);
        g.drawString(s, x, y);
    }

    public static Color setAlpha(Color baseColor, int newAlpha) {
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), newAlpha);
    }

    public static Composite setAlpha(Graphics2D g, float alpha) {
        Composite composite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, alpha));
        return composite;
    }

    public static Composite setAlphaNullable(Graphics2D g, float alpha) {
        if (alpha >= 1.0f) {
            return null;
        }
        Composite composite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, alpha));
        return composite;
    }

    public static Color multiplyAlpha(Color baseColor, float newAlpha) {
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), (int)((float)baseColor.getAlpha() * newAlpha));
    }

    public static Color apply(Color base, Color onTop) {
        float multiplierOnTop = (float)onTop.getAlpha() / 255.0f;
        float multiplierBase = 1.0f - multiplierOnTop;
        return new Color((int)((float)base.getRed() * multiplierBase + (float)onTop.getRed() * multiplierOnTop), (int)((float)base.getGreen() * multiplierBase + (float)onTop.getGreen() * multiplierOnTop), (int)((float)base.getBlue() * multiplierBase + (float)onTop.getBlue() * multiplierOnTop), Math.min(255, base.getAlpha() + onTop.getAlpha()));
    }

    public static Cursor createHiddenCursor() {
        return Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(16, 16, 2), new Point(0, 0), "invisible");
    }

    public static void trySetAlwaysOnTop(Window window) {
        if (window.getToolkit().isAlwaysOnTopSupported() && window.isAlwaysOnTopSupported()) {
            window.setAlwaysOnTop(true);
        }
    }

    public static Font loadFont(String resource) throws IOException, FontFormatException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream in = MiscIO.getResource(resource);){
            return Font.createFont(0, in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Font loadFontRegister(String resource) throws IOException, FontFormatException {
        Font font = MiscAWT.loadFont(resource);
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
        return font;
    }

    public static void setOpenGL(boolean force) {
        if (force) {
            System.setProperty("sun.java2d.d3d", "false");
            System.setProperty("sun.java2d.opengl", "true");
        }
    }

    public static void setMinimumWindowSize(JFrame window, Dimension minSize) {
        Dimension csize = window.getContentPane().getSize();
        Dimension size = window.getSize();
        int frameW = size.width - csize.width;
        int frameH = size.height - csize.height;
        window.setMinimumSize(new Dimension(minSize.width + frameW, minSize.height + frameH));
    }

    public static IDisposable bindCommand(AbstractButton button, Command command) {
        boolean startState = button.isEnabled();
        ActionListener al = evt -> {
            boolean bl = command.tryPerform();
        };
        button.addActionListener(al);
        BoolBinding binding = command.bind(button::setEnabled);
        return () -> {
            button.removeActionListener(al);
            binding.dispose();
            button.setEnabled(startState);
        };
    }

    public static IDisposable bindCommandPlusVisibility(AbstractButton button, Command command) {
        boolean startState = button.isVisible();
        ActionListener al = evt -> {
            boolean bl = command.tryPerform();
        };
        button.addActionListener(al);
        BoolBinding binding = command.bind(x -> {
            button.setEnabled(x);
            button.setVisible(x);
        });
        return () -> {
            button.removeActionListener(al);
            binding.dispose();
            button.setEnabled(startState);
            button.setVisible(startState);
        };
    }

    public static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static IDisposable bind(ListModel<?> listModel, final Runnable onChanged) {
        Misc.notNull(listModel);
        Misc.notNull(onChanged);
        ListDataListener listener = new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                onChanged.run();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                onChanged.run();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                onChanged.run();
            }
        };
        listModel.addListDataListener(listener);
        onChanged.run();
        return () -> listModel.removeListDataListener(listener);
    }

    public static IDisposable bind(SpinnerModel model, Runnable onChanged) {
        Misc.notNull(model);
        Misc.notNull(onChanged);
        ChangeListener listener = evt -> onChanged.run();
        model.addChangeListener(listener);
        onChanged.run();
        return () -> model.removeChangeListener(listener);
    }

    public static IDisposable bind(Document document, final Runnable onChanged) {
        Misc.notNull(document);
        Misc.notNull(onChanged);
        DocumentListener listener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                onChanged.run();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                onChanged.run();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                onChanged.run();
            }
        };
        document.addDocumentListener(listener);
        onChanged.run();
        return () -> document.removeDocumentListener(listener);
    }

    public static IDisposable bind(AbstractButton button, BoolConsumer consumer) {
        ItemListener itemListener = evt -> consumer.accept(button.isSelected());
        button.addItemListener(itemListener);
        itemListener.itemStateChanged(null);
        return () -> button.removeItemListener(itemListener);
    }

    public static void setSize(Component component, Dimension size) {
        component.setMinimumSize(size);
        component.setPreferredSize(size);
        component.setMaximumSize(size);
    }

    public static ListDataListener createSimpleListDataListener(final Runnable onChanged) {
        return new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
                onChanged.run();
            }

            @Override
            public void intervalAdded(ListDataEvent arg0) {
                onChanged.run();
            }

            @Override
            public void contentsChanged(ListDataEvent arg0) {
                onChanged.run();
            }
        };
    }

    public static void disableHTML(JComponent label) {
        label.putClientProperty("html.disable", Boolean.TRUE);
    }

    public static IDisposable createEDTKeepalive() {
        JWindow window = new JWindow();
        window.setVisible(true);
        window.setVisible(false);
        return window::dispose;
    }

    public static void disableMouse(Component ... components) {
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            EventListener l;
            Component c = componentArray[n2];
            if (c instanceof Container) {
                MiscAWT.disableMouse(((Container)c).getComponents());
            }
            EventListener[] eventListenerArray = c.getMouseListeners();
            int n3 = eventListenerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                l = eventListenerArray[n4];
                c.removeMouseListener((MouseListener)l);
                ++n4;
            }
            eventListenerArray = c.getMouseMotionListeners();
            n3 = eventListenerArray.length;
            n4 = 0;
            while (n4 < n3) {
                l = eventListenerArray[n4];
                c.removeMouseMotionListener((MouseMotionListener)l);
                ++n4;
            }
            ++n2;
        }
    }

    public static void setCursor(Component component, Cursor cursor) {
        if (component.isCursorSet()) {
            if (cursor == null || component.getCursor() != cursor) {
                component.setCursor(cursor);
            }
        } else if (cursor != null) {
            component.setCursor(cursor);
        }
    }

    public static boolean inBounds(Point pos, int width, int height) {
        return pos.x >= 0 && pos.y >= 0 && pos.x < width && pos.y < height;
    }

    public static boolean inBounds(Point pos, Dimension size) {
        return pos.x >= 0 && pos.y >= 0 && pos.x < size.width && pos.y < size.height;
    }

    public static boolean inBounds(int x, int y, Dimension size) {
        return x >= 0 && y >= 0 && x < size.width && y < size.height;
    }

    public static boolean equals(Point pos, int x, int y) {
        return pos.x == x && pos.y == y;
    }

    public static void maximizeFrame(Frame frame) {
        frame.setExtendedState(frame.getExtendedState() | 6);
    }

    public static int taxiDistance(Point p1, Point p2) {
        return Misc2D.taxiDistance(p1.x, p1.y, p2.x, p2.y);
    }

    public static int taxiDistance(Point p1, int x, int y) {
        return Misc2D.taxiDistance(p1.x, p1.y, x, y);
    }

    public static int getTaxiDistanceWithDiagonal(Point p1, Point p2) {
        int valX = Math.abs(p1.x - p2.x);
        int valY = Math.abs(p1.y - p2.y);
        int smaller = Math.min(valX, valY);
        return valX + valY - smaller;
    }

    public static boolean hasMask(InputEvent e, int mask) {
        return (e.getModifiersEx() & mask) != 0;
    }

    public static boolean isCtrlDown(InputEvent e) {
        return MiscAWT.hasMask(e, 128);
    }

    public static boolean isShiftDown(InputEvent e) {
        return MiscAWT.hasMask(e, 64);
    }

    public static boolean isAltDown(InputEvent e) {
        return MiscAWT.hasMask(e, 512);
    }

    public static int getRGBA(Color color) {
        return color.getRGB() | color.getAlpha() << 24;
    }

    public static void setProgressbar(JProgressBar progressBar, Double progress) {
        if (progress == null) {
            if (!progressBar.isIndeterminate()) {
                progressBar.setIndeterminate(true);
            }
        } else {
            int newValue;
            if (progressBar.isIndeterminate()) {
                progressBar.setIndeterminate(false);
            }
            if ((newValue = (int)(progress * (double)progressBar.getMaximum())) != progressBar.getValue()) {
                progressBar.setValue(newValue);
            }
        }
    }
}

