/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import com.iosoft.helpers.ui.awt.MiscAWT;
import java.awt.Component;
import javax.swing.JTextPane;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class GameTextPane
extends JTextPane {
    private static final long serialVersionUID = 1L;

    public GameTextPane() {
        this.setOpaque(false);
        this.setText("");
        this.setEditable(false);
        this.setFocusable(false);
        this.setDragEnabled(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.setEditorKit(new WrapEditorKit());
    }

    public GameTextPane(String text) {
        this();
        this.setText(text);
    }

    public GameTextPane(String text, Component parent) {
        this(parent);
        this.setText(text);
    }

    public GameTextPane(String text, Component parent, int x, int y, int w, int h) {
        this(text, parent);
        this.setBounds(x, y, w, h);
    }

    public GameTextPane(Component parent) {
        this();
        if (parent != null) {
            MiscAWT.doDefaults(this, parent);
        }
    }

    public void append(String s) {
        this.setText(String.valueOf(this.getText()) + s);
    }

    public void setHorizontalCentered() {
        this.setAlign(1);
    }

    public void setAlign(int align) {
        StyledDocument doc = this.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, align);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
    }

    public void makeMouseTransparent() {
        this.disableEvents(48L);
        MiscAWT.disableMouse(this);
    }

    private static class WrapColumnFactory
    implements ViewFactory {
        private WrapColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            block19: {
                String kind = elem.getName();
                if (kind == null) break block19;
                switch (kind) {
                    case "content": {
                        return new WrapLabelView(elem);
                    }
                    case "paragraph": {
                        return new ParagraphView(elem);
                    }
                    case "section": {
                        return new BoxView(elem, 1);
                    }
                    case "component": {
                        return new ComponentView(elem);
                    }
                    case "icon": {
                        return new IconView(elem);
                    }
                }
            }
            return new LabelView(elem);
        }
    }

    private static class WrapEditorKit
    extends StyledEditorKit {
        private static final long serialVersionUID = 1L;
        private final ViewFactory defaultFactory = new WrapColumnFactory();

        private WrapEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }

    private static class WrapLabelView
    extends LabelView {
        WrapLabelView(Element elem) {
            super(elem);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }
}

