/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.ui.ActionableUI;
import com.iosoft.helpers.ui.awt.AntialiasedLabel;
import com.iosoft.helpers.ui.awt.MiscAWT;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GameButton
extends JPanel
implements ActionableUI {
    private static final long serialVersionUID = 1L;
    protected boolean isInButton;
    protected boolean isClicked;
    protected JLabel label;
    protected final List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    protected Image _img;
    protected int imgX;
    protected int imgY;
    protected int imgW;
    protected int imgH;
    protected static final Font fontButton = new Font("Verdana", 0, 20);
    protected static final Color DISABLEDBACKGROUND = new Color(70, 70, 70);
    protected static final Color NEWBACKGROUND = new Color(100, 100, 100);
    protected static final Color DISABLED = new Color(100, 100, 100);
    protected Color colorBG;
    protected Color colorBGDisabled;
    protected Color colorBGDown;
    protected Color colorText;
    protected Color colorTextDisabled;
    protected Color colorTextDown;
    protected Color colorImageDisabled;
    protected Border borderUp;
    protected Border borderDown;

    public GameButton(int x, int y, int width, int height, String text) {
        this();
        this.setText(text);
        this.setBounds(x, y, width, height);
    }

    public GameButton(String text) {
        this();
        this.setText(text);
    }

    public GameButton() {
        super(new BorderLayout());
        this.setFocusable(true);
        this.borderUp = BorderFactory.createRaisedBevelBorder();
        this.borderDown = BorderFactory.createLoweredBevelBorder();
        this.colorBG = Color.LIGHT_GRAY;
        this.colorBGDisabled = DISABLEDBACKGROUND;
        this.colorBGDown = NEWBACKGROUND;
        this.colorText = Color.BLACK;
        this.colorTextDisabled = DISABLED;
        this.colorTextDown = Color.BLACK;
        this.makeImageBG();
        this.label = this.createLabel();
        this.label.setHorizontalAlignment(0);
        this.label.setFont(fontButton);
        this.label.setForeground(Color.BLACK);
        if (this._img != null) {
            this.label.setVisible(false);
            this.imgW = this._img.getWidth(null);
            this.imgH = this._img.getHeight(null);
        }
        this.add((Component)this.label, "Center");
        MyMouseListener ml = new MyMouseListener();
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (GameButton.this.isEnabled() && e.getKeyCode() == 10) {
                    GameButton.this.onClick();
                }
            }
        });
        this.setState();
    }

    protected JLabel createLabel() {
        return new AntialiasedLabel();
    }

    protected void onHover() {
    }

    protected void onClick() {
        this.doClick();
    }

    public void setImage(Image img) {
        this._img = img;
        this.label.setVisible(img == null);
        if (img != null) {
            this.imgW = img.getWidth(null);
            this.imgH = img.getHeight(null);
            this.imgX = (this.getWidth() - this.imgW) / 2;
            this.imgY = (this.getHeight() - this.imgH) / 2;
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.imgX = (this.getWidth() - this.imgW) / 2;
        this.imgY = (this.getHeight() - this.imgH) / 2;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        MiscAWT.setAA(g);
        super.paintComponent(g);
        if (this._img != null) {
            g.drawImage(this._img, this.imgX, this.imgY, null);
            if (!this.isEnabled()) {
                g.setColor(this.colorImageDisabled);
                g.fillRect(this.imgX, this.imgY, this.imgW, this.imgH);
            }
        }
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setState();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setState();
    }

    @Override
    public IDisposable addOnAction(Runnable action) {
        ActionListener al = evt -> action.run();
        this.addActionListener(al);
        return () -> this.removeActionListener(al);
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.isInButton = false;
        this.isClicked = false;
        this.setState();
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    protected void setState() {
        if (this.isEnabled()) {
            if (this.isClicked && this.isInButton) {
                this.label.setForeground(this.colorTextDown);
                this.setBorder(this.borderDown);
                this.setBackground(this.colorBGDown);
            } else {
                this.label.setForeground(this.colorText);
                this.setBorder(this.borderUp);
                this.setBackground(this.colorBG);
            }
        } else {
            this.label.setForeground(this.colorTextDisabled);
            this.setBorder(this.borderUp);
            this.setBackground(this.colorBGDisabled);
        }
    }

    protected void makeImageBG() {
        this.colorImageDisabled = new Color(this.colorTextDisabled.getRed(), this.colorTextDisabled.getGreen(), this.colorTextDisabled.getBlue(), 100);
    }

    public void doClick() {
        if (!this.actionListeners.isEmpty()) {
            ActionEvent e = new ActionEvent(this, 1001, "click2");
            for (ActionListener al : this.actionListeners) {
                al.actionPerformed(e);
            }
        }
    }

    protected void doTLA() {
        MiscAWT.repaintWindow(this);
    }

    public void resetOMOEffect() {
        this.isInButton = false;
        this.isClicked = false;
        this.setState();
    }

    private boolean isInside(Point p) {
        return p.x >= 0 && p.y >= 0 && p.x < this.getWidth() && p.y < this.getHeight();
    }

    private class MyMouseListener
    implements MouseListener,
    MouseMotionListener {
        MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            if (e.getButton() == 1) {
                GameButton.this.isClicked = true;
            }
            GameButton.this.setState();
            GameButton.this.doTLA();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            if (e.getButton() == 1) {
                if (GameButton.this.isClicked && GameButton.this.isInButton && GameButton.this.isEnabled() && GameButton.this.isVisible()) {
                    GameButton.this.onClick();
                }
                GameButton.this.isClicked = false;
            }
            GameButton.this.setState();
            GameButton.this.doTLA();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (GameButton.this.isEnabled()) {
                GameButton.this.onHover();
            }
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            GameButton.this.setState();
            GameButton.this.doTLA();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            GameButton.this.setState();
            GameButton.this.doTLA();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            GameButton.this.isClicked = true;
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            GameButton.this.setState();
            GameButton.this.doTLA();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            GameButton.this.isClicked = false;
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            GameButton.this.setState();
            GameButton.this.doTLA();
        }
    }
}

