/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import com.iosoft.helpers.IDisposable;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class EventPasser
implements MouseListener {
    private final Component component;

    public EventPasser(Component component) {
        this.component = component;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.passToParent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.passToParent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.passToParent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.passToParent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.passToParent(e);
    }

    public void passToParent(AWTEvent event) {
        System.out.println(event);
        Container parent = this.component.getParent();
        if (parent != null) {
            parent.dispatchEvent(event);
        }
    }

    public static IDisposable toParent(Component component) {
        EventPasser passer = new EventPasser(component);
        component.addMouseListener(passer);
        return () -> component.removeMouseListener(passer);
    }
}

