/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network.util;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.io.DataHelper;
import com.iosoft.helpers.network.ReceivingCallback;
import com.iosoft.helpers.network.ReceivingFunction;
import com.iosoft.helpers.network.util.NetworkMessage;
import com.iosoft.helpers.network.util.NetworkMessageCallback;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class NetworkMessageHandler {
    public static final int NumMaxCallbacks = 256;
    private final DataHelper dataHelper = new DataHelper();
    private final ReceivingCallback[] registered = new ReceivingCallback[256];
    public Consumer<Exception> UncaughtExceptionHandler;
    public ReceivingCallback StateChecker;

    public <T extends NetworkMessage> void registerMessage(ReceivingFunction<T> factory, Consumer<T> handler) {
        try {
            this.registerCallback(((NetworkMessage)factory.apply(null)).getMessageID(), receiver -> {
                NetworkMessage dto = (NetworkMessage)factory.apply(receiver);
                dto.read(receiver.Stream);
                receiver.post(() -> {
                    try {
                        handler.accept(dto);
                    }
                    catch (Exception e) {
                        if (this.UncaughtExceptionHandler == null) {
                            throw e;
                        }
                        this.UncaughtExceptionHandler.accept(e);
                    }
                });
            });
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
    }

    public <T extends NetworkMessage> void registerMessage(Supplier<T> factory, Consumer<T> handler) {
        this.registerCallback(((NetworkMessage)factory.get()).getMessageID(), receiver -> {
            NetworkMessage dto = (NetworkMessage)factory.get();
            dto.read(receiver.Stream);
            receiver.post(() -> {
                try {
                    handler.accept(dto);
                }
                catch (Exception e) {
                    if (this.UncaughtExceptionHandler == null) {
                        throw e;
                    }
                    this.UncaughtExceptionHandler.accept(e);
                }
            });
        });
    }

    public void registerCallback(byte messageID, ReceivingCallback callback) {
        ReceivingCallback stateChecker = this.StateChecker;
        int index = Byte.toUnsignedInt(messageID);
        if (this.registered[index] != null) {
            throw new IllegalArgumentException("MessageID already used");
        }
        this.registered[index] = stateChecker == null ? callback : x -> {
            try {
                stateChecker.accept(x);
            }
            catch (IOException e) {
                Log.Developer.error("Msg " + index + " in bad state");
                throw e;
            }
            callback.accept(x);
        };
    }

    public void unregisterCallback(byte messageID) {
        int index = Byte.toUnsignedInt(messageID);
        this.registered[index] = null;
    }

    public ReceivingCallback createReceivingCallback(boolean looping) {
        return new NetworkMessageCallback(this.registered, looping);
    }

    public byte[] write(NetworkMessage msg) {
        try {
            msg.writeMessage(this.dataHelper.Stream);
            return this.dataHelper.finish();
        }
        catch (IOException e) {
            throw new WrapException("DataHelper error?", e);
        }
    }
}

