/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network.util;

import com.iosoft.helpers.network.ReceiverHelper;
import com.iosoft.helpers.network.ReceivingCallback;
import com.iosoft.helpers.network.util.NetworkMessageException;
import java.io.IOException;
import java.util.Arrays;

public class NetworkMessageCallback
implements ReceivingCallback {
    private final ReceivingCallback[] _lookup;
    private final boolean _looping;

    public NetworkMessageCallback(ReceivingCallback[] lookup, boolean looping) {
        this._lookup = Arrays.copyOf(lookup, 256);
        this._looping = looping;
    }

    @Override
    public void accept(ReceiverHelper receiver) throws IOException {
        int previousMessage = -1;
        do {
            int messageId = receiver.Stream.readUnsignedByte();
            receiver.checkDisconnecting();
            ReceivingCallback entry = this._lookup[messageId];
            if (entry == null) {
                throw new NetworkMessageException("Unknown network message ID '" + messageId + "' (previous message ID was '" + previousMessage + "')");
            }
            previousMessage = messageId;
            entry.accept(receiver);
        } while (this._looping);
    }
}

