/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network.tcp;

import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.network.MiscNet;
import java.net.Socket;

public final class TcpOptions
implements Cloneable {
    public static final TcpOptions Default = new TcpOptions();
    public Boolean Nodelay;
    public boolean TurnOffLinger;
    public boolean LowLatencyHint;
    public Boolean Reuse;

    static {
        TcpOptions.Default.Nodelay = true;
        TcpOptions.Default.TurnOffLinger = true;
        TcpOptions.Default.LowLatencyHint = true;
        TcpOptions.Default.Reuse = true;
    }

    public boolean tryApply(Socket socket) {
        boolean reuseWorked;
        boolean lingerWorked;
        boolean nodelayWorked = this.Nodelay == null || MiscNet.trySetTcpNodelay(socket, this.Nodelay);
        boolean bl = lingerWorked = !this.TurnOffLinger || MiscNet.tryDisableLinger(socket);
        if (this.LowLatencyHint) {
            MiscNet.setLowLatency(socket);
        }
        boolean bl2 = reuseWorked = this.Reuse == null || MiscNet.trySetReuse(socket, this.Reuse);
        return nodelayWorked && lingerWorked && reuseWorked;
    }

    public TcpOptions copy() {
        try {
            return (TcpOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new WrapException(e);
        }
    }
}

