/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network.tcp;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.SubProcess;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.network.tcp.TcpOptions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class TcpListener
implements IDisposable {
    private ListenerWorker lastWorker;
    private char currentPort = '\u0000';
    private final BiConsumer<Socket, Runnable> handler;
    public TcpOptions Options = TcpOptions.Default;
    public int Backlog = 3;
    public Consumer<IOException> ErrorHandler;

    public TcpListener(BiConsumer<Socket, Runnable> handler) {
        this.handler = Misc.notNull(handler);
    }

    public TcpListener(Function<Socket, VTask> handler) {
        Misc.notNull(handler);
        this.handler = (socket, continuer) -> ((VTask)handler.apply((Socket)socket)).await(continuer);
    }

    public TcpListener(Consumer<Socket> handler) {
        Misc.notNull(handler);
        this.handler = (socket, continuer) -> {
            try {
                handler.accept((Socket)socket);
            }
            finally {
                continuer.run();
            }
        };
    }

    public boolean tryStart(InetAddress forceAddr, char port) {
        try {
            this.start(forceAddr, port);
            return true;
        }
        catch (IOException ex) {
            String message = ex.getMessage();
            if (message != null && message.startsWith("Address already in use")) {
                Log.Server.error("TcpListener could not start (" + message + ")");
            } else {
                Log.Server.errorFull("TcpListener could not start", ex);
            }
            return false;
        }
    }

    public void start(InetAddress forceAddr, char port) throws IOException {
        if (this.isRunning()) {
            if (this.currentPort == port) {
                return;
            }
            this.stop();
        }
        this.currentPort = port;
        ServerSocket server = new ServerSocket();
        if (this.Options != null && this.Options.Reuse != null) {
            server.setReuseAddress(this.Options.Reuse);
        }
        try {
            server.bind(new InetSocketAddress(forceAddr, (int)port), this.Backlog);
            this.currentPort = (char)server.getLocalPort();
            this.lastWorker = new ListenerWorker(server);
        }
        catch (Throwable t) {
            Misc.forceClose(server);
            throw t;
        }
    }

    public char getPort() {
        return this.currentPort;
    }

    public boolean isRunning() {
        return this.lastWorker != null;
    }

    public void stop() {
        if (this.lastWorker != null) {
            this.lastWorker.end();
            this.lastWorker = null;
        }
    }

    @Override
    public void dispose() {
        this.stop();
    }

    private void preHandle(Socket socket, Runnable continuer) {
        TcpOptions options = this.Options;
        if (options != null) {
            options.tryApply(socket);
        }
        this.handler.accept(socket, continuer);
    }

    private class ListenerWorker
    extends SubProcess {
        private final ServerSocket server;

        ListenerWorker(ServerSocket server) {
            this.server = server;
            this.start("TcpListener " + server.getLocalSocketAddress(), () -> {
                try {
                    while (!Thread.interrupted()) {
                        Socket socket = server.accept();
                        this._dispatcher.dispatchCreateWaiter(continuer -> {
                            if (this.isRunning()) {
                                TcpListener.this.preHandle(socket, continuer);
                            } else {
                                Misc.forceClose(socket);
                                continuer.run();
                            }
                        }).waitBlockingInterruptible();
                    }
                }
                catch (IOException ex) {
                    Misc.forceClose(server);
                    this.post(() -> {
                        TcpListener.this.lastWorker = null;
                        if (TcpListener.this.ErrorHandler == null) {
                            this._dispatcher.handleUnhandledException(ex);
                        } else {
                            TcpListener.this.ErrorHandler.accept(ex);
                        }
                    });
                }
                catch (InterruptedException e) {
                    return;
                }
            });
        }

        @Override
        protected void onEnd() {
            super.onEnd();
            Misc.forceClose(this.server);
        }
    }
}

