/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network.tcp;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.WeirdException;
import com.iosoft.helpers.network.IInetConnection;
import com.iosoft.helpers.network.ReceivingCallback;
import com.iosoft.helpers.network.StreamConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;

public final class TcpConnection
extends StreamConnection
implements IInetConnection {
    private Socket socket;

    public TcpConnection(Socket socket) throws WeirdException {
        this(socket, null, true, null);
    }

    public TcpConnection(Socket socket, ReceivingCallback receive) throws WeirdException {
        this(socket, receive, true, null);
    }

    public TcpConnection(Socket socket, ReceivingCallback receive, String prefix) throws WeirdException {
        this(socket, receive, true, prefix);
    }

    public TcpConnection(Socket socket, ReceivingCallback receive, boolean buffered, String prefix) throws WeirdException {
        OutputStream out;
        InputStream in;
        Misc.notNull(socket);
        this.socket = socket;
        this.setPrefix(prefix);
        try {
            in = socket.getInputStream();
            out = socket.getOutputStream();
            if (buffered) {
                in = new BufferedInputStream(in);
                out = new BufferedOutputStream(out);
            }
        }
        catch (IOException ex) {
            Misc.forceClose(socket);
            throw new WeirdException("Socket already closed", ex);
        }
        this.initialize(in, out, receive);
    }

    @Override
    protected void closeReceiverOnly() {
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void onClose() {
        super.onClose();
        Misc.forceClose(this.socket);
    }

    @Override
    public int getRemotePort() {
        return this.socket.getPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public SocketAddress getRemotePeer() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public SocketAddress getLocalPeer() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }
}

