/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network.tcp;

import com.iosoft.helpers.FailableResult;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.TaskWorker;
import com.iosoft.helpers.network.IpPort;
import com.iosoft.helpers.network.tcp.TcpOptions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public final class TcpConnecter {
    public static Task<ResolveResult> resolveAddressAsync(final String address) {
        return new TaskWorker<ResolveResult>("IP address resolver"){

            @Override
            protected ResolveResult doWork() {
                try {
                    return new ResolveResult(InetAddress.getByName(address));
                }
                catch (UnknownHostException e) {
                    Log.Client.error("Cannot resolve IP address '" + address + "': " + e);
                    return new ResolveResult(e);
                }
            }
        }.startTask();
    }

    public static Task<Result> connectAsync(String ip, char port) {
        return TcpConnecter.connectAsync(new IpPort(ip, port), TcpOptions.Default);
    }

    public static Task<Result> connectAsync(String ip, char port, TcpOptions options) {
        return TcpConnecter.connectAsync(new IpPort(ip, port), options);
    }

    public static Task<Result> connectAsync(IpPort target, TcpOptions options) {
        return TcpConnecter.resolveAddressAsync(target.IpAddress).awaitAndContinueTask(address -> {
            if (address.Exception != null) {
                return new Task<Result>(new Result((Exception)address.Exception));
            }
            return TcpConnecter.connectAsync((InetAddress)address.Value, ipPort.Port, options);
        });
    }

    public static Task<Result> connectAsync(InetAddress address, char port) {
        return TcpConnecter.connectAsync(address, port, TcpOptions.Default);
    }

    public static Task<Result> connectAsync(InetAddress address, char port, TcpOptions options) {
        return TcpConnecter.connectAsync(address, port, null, options);
    }

    public static Task<Result> connectAsync(SocketAddress address, TcpOptions options) {
        return TcpConnecter.connectAsync(null, '\u0000', address, options);
    }

    private static Task<Result> connectAsync(final InetAddress address, final char port, final SocketAddress fullAddress, final TcpOptions options) {
        return new TaskWorker<Result>("Connecter"){
            private final Socket socket;
            {
                super($anonymous0);
                this.socket = new Socket();
            }

            @Override
            protected void handleCancelled(Result result) {
                Misc.forceClose(this.socket);
            }

            @Override
            protected Result doWork() {
                try {
                    if (options != null) {
                        options.tryApply(this.socket);
                    }
                    this.socket.connect(fullAddress == null ? new InetSocketAddress(address, (int)port) : fullAddress);
                    return new Result(this.socket);
                }
                catch (IOException | IllegalArgumentException ex) {
                    return new Result(ex);
                }
            }

            @Override
            protected void onAbort() {
                super.onAbort();
                this.handleCancelled(null);
            }
        }.startTask();
    }

    private TcpConnecter() {
    }

    public static class ResolveResult
    extends FailableResult<InetAddress, UnknownHostException> {
        public ResolveResult(InetAddress value) {
            super(value);
        }

        public ResolveResult(UnknownHostException exception) {
            super(exception);
        }
    }

    public static class Result
    extends FailableResult<Socket, Exception> {
        public Result(Socket value) {
            super(value);
        }

        public Result(Exception exception) {
            super(exception);
        }
    }
}

