/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network.lag;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.network.AbstractConnection;
import com.iosoft.helpers.network.IConnection;
import com.iosoft.helpers.network.Receiver;
import com.iosoft.helpers.network.ReceiverHelper;
import com.iosoft.helpers.network.ReceivingCallback;
import com.iosoft.helpers.network.Sender;
import com.iosoft.helpers.network.StreamPair;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.function.Consumer;

public class LagConnection<T extends IConnection>
extends AbstractConnection {
    public double LagReceiveSeconds = 0.5;
    public double LagReceiveSecondsRandom = 0.0;
    public double LagSendSeconds = 0.5;
    public double LagSendSecondsRandom = 0.0;
    private final LinkedList<Message> _sendBuffer = new LinkedList();
    private final LinkedList<Message> _receiveBuffer = new LinkedList();
    private final Sender _sender;
    private final ReceiverHelper _receiverHelper;
    private final StreamPair _streams;
    private boolean _buffering = false;
    private int _bufferingMessagesRemaining;
    private int _bufferSize;
    private boolean _connected = true;
    private IDisposable _delay;
    private long _delayTarget;
    protected T _wrappedConnection;

    public LagConnection(ReceivingCallback receivingCallback) {
        try {
            PipedOutputStream out = new PipedOutputStream();
            PipedInputStream in = new PipedInputStream(out);
            this._streams = new StreamPair(out, in);
            this._sender = new Sender("LagConnection Sender", out, this::somethingDisconnected);
            this._receiverHelper = new ReceiverHelper(Dispatcher.getForCurrentThread(), in, this::isConnected);
            new Receiver("LagConnection Receiver", receivingCallback, this._receiverHelper, this::somethingDisconnected);
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
    }

    public void initialize(T connection) {
        Misc.notNull(connection);
        if (this._wrappedConnection != null) {
            throw new IllegalStateException("Already initialized");
        }
        this._wrappedConnection = connection;
        connection.eventOnDisconnected().register((Exception)((Object)((Consumer<Exception>)this::somethingDisconnected)));
        connection.setSending(false);
    }

    @Override
    public void disconnect(double timeForRemainingMessagesInSeconds) {
        if (this.internalDisconnect(timeForRemainingMessagesInSeconds)) {
            this._eventOnDisconnected.fire(null);
        }
    }

    private boolean internalDisconnect(double timeForRemainingMessagesInSeconds) {
        if (!this.isConnected()) {
            return false;
        }
        this._connected = false;
        this._receiverHelper.Disconnecting = true;
        this.abortDelay();
        this._sendBuffer.clear();
        this._receiveBuffer.clear();
        this._sender.end();
        this._streams.close();
        if (this._wrappedConnection.isConnected()) {
            this._wrappedConnection.disconnect(timeForRemainingMessagesInSeconds);
        }
        return true;
    }

    private void abortDelay() {
        if (this._delay != null) {
            this._delay.dispose();
            this._delay = null;
        }
    }

    private void somethingDisconnected(Exception e) {
        if (this.internalDisconnect(0.0)) {
            this._eventOnDisconnected.fire(e);
        }
    }

    private static long getDelay(double baseDelay, double randomDelay) {
        return Stopwatch.start() + Stopwatch.fromSeconds(baseDelay + Misc.random(randomDelay));
    }

    @Override
    public void send(byte[] data, boolean reliable) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        this._bufferSize += data.length;
        this._sendBuffer.add(new Message(data, reliable, LagConnection.getDelay(this.LagSendSeconds, this.LagSendSecondsRandom)));
        this.tick();
    }

    private void tick() {
        Message message;
        long now = Stopwatch.start();
        long nextAction = Long.MAX_VALUE;
        boolean nextActionExists = false;
        boolean messageSent = false;
        while (!(this._sendBuffer.isEmpty() || this._buffering && this._bufferingMessagesRemaining <= 0)) {
            message = this._sendBuffer.getFirst();
            if (now < message.SendAt) {
                nextActionExists = true;
                nextAction = message.SendAt;
                break;
            }
            this._sendBuffer.removeFirst();
            if (this._buffering) {
                --this._bufferingMessagesRemaining;
            }
            this._bufferSize -= message.Data.length;
            messageSent = true;
            this._wrappedConnection.send(message.Data, message.Reliable);
        }
        if (messageSent) {
            this._wrappedConnection.flushMessages();
        }
        while (!this._receiveBuffer.isEmpty()) {
            message = this._receiveBuffer.getFirst();
            if (now < message.SendAt) {
                if (nextActionExists && message.SendAt >= nextAction) break;
                nextActionExists = true;
                nextAction = message.SendAt;
                break;
            }
            this._receiveBuffer.removeFirst();
            this._sender.send(message.Data);
        }
        if (!nextActionExists) {
            this.abortDelay();
        } else if (this._delay == null || this._delayTarget > nextAction) {
            this.abortDelay();
            this._delayTarget = nextAction;
            this._delay = Dispatcher.getForCurrentThread().delay(Stopwatch.getSeconds(now, nextAction), this::onTick);
        }
    }

    private void onTick() {
        this._delay = null;
        this.tick();
    }

    @Override
    public boolean isConnected() {
        return this._connected;
    }

    @Override
    public void flushMessages() {
        this._bufferingMessagesRemaining = this._sendBuffer.size();
        this.tick();
    }

    @Override
    public void setSending(boolean sending) {
        this.flushMessages();
    }

    @Override
    public boolean isSending() {
        return !this._buffering;
    }

    @Override
    public int getBufferSize() {
        return this._bufferSize;
    }

    @Override
    public long getBytesSent() {
        return this._wrappedConnection.getBytesSent();
    }

    @Override
    public long getPacketsSent() {
        return this._wrappedConnection.getPacketsSent();
    }

    public void delayedReceivingCallback(ReceiverHelper arg) throws IOException {
        byte[] buffer = new byte[8192];
        while (true) {
            arg.checkDisconnecting();
            int length = arg.Stream.read(buffer);
            if (length < 1) {
                arg.skip();
            }
            byte[] message = Arrays.copyOf(buffer, length);
            arg.post(() -> {
                this._receiveBuffer.add(new Message(message, true, LagConnection.getDelay(this.LagReceiveSeconds, this.LagReceiveSecondsRandom)));
                this.tick();
            });
        }
    }

    private static class Message {
        final byte[] Data;
        final boolean Reliable;
        final long SendAt;

        Message(byte[] data, boolean reliable, long sendAt) {
            this.Data = data;
            this.Reliable = reliable;
            this.SendAt = sendAt;
        }
    }
}

