/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.network.AbstractConnection;
import com.iosoft.helpers.network.Receiver;
import com.iosoft.helpers.network.ReceiverHelper;
import com.iosoft.helpers.network.ReceivingCallback;
import com.iosoft.helpers.network.Sender;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class StreamConnection
extends AbstractConnection {
    private static volatile int counter = 0;
    private final Dispatcher dispatcher = Dispatcher.getForCurrentThread();
    private final int number;
    private boolean connected = true;
    private boolean started;
    private String prefix;
    private Sender sender;
    private ReceiverHelper lastReceiverHelper;
    private VTask _taskPendingSenderDisconnect;

    public StreamConnection() {
        if (counter == Integer.MAX_VALUE) {
            counter = Integer.MIN_VALUE;
        }
        this.number = counter++;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public int getBufferSize() {
        return this.sender.getBufferSize();
    }

    public void ensureNotStarted() {
        if (this.started) {
            throw new IllegalStateException("already bound");
        }
    }

    @Override
    public long getBytesSent() {
        return this.sender.getBytesSent();
    }

    @Override
    public long getPacketsSent() {
        return this.sender.getPacketsSent();
    }

    protected void initialize(InputStream in, OutputStream out, ReceivingCallback receive) {
        Misc.notNull(in);
        Misc.notNull(out);
        this.started = true;
        String pre = this.prefix == null ? "" : String.valueOf(this.prefix) + " ";
        String post = " (#" + this.number + ")";
        this.sender = new Sender(String.valueOf(pre) + "Sender" + post, out, this::internalDisconnect);
        this.lastReceiverHelper = new ReceiverHelper(this.dispatcher, in, this::isConnected);
        new Receiver(String.valueOf(pre) + "Receiver" + post, receive, this.lastReceiverHelper, this::internalDisconnect);
    }

    @Override
    public void send(byte[] data, boolean reliable) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Connection is closed");
        }
        Misc.notNull(data);
        if (data.length == 0) {
            return;
        }
        this.sender.send(data);
    }

    @Override
    public void flushMessages() {
        this.sender.flushMessages();
    }

    @Override
    public void setSending(boolean sending) {
        this.sender.setBufferMessages(!sending);
    }

    @Override
    public boolean isSending() {
        return !this.sender.isBufferingMessages();
    }

    @Override
    public final boolean isConnected() {
        return this.connected;
    }

    protected void onClose() {
        this.sender.end();
    }

    private void internalDisconnect(Exception ex) {
        this.internalDisconnect(ex, 0.0);
    }

    private void internalDisconnect(Exception ex, double timeForRemainingMessagesInSeconds) {
        if (!this.isConnected()) {
            return;
        }
        this.lastReceiverHelper.Disconnecting = true;
        this.lastReceiverHelper = null;
        this.connected = false;
        if (timeForRemainingMessagesInSeconds > 0.0) {
            this._taskPendingSenderDisconnect = VTask.delay(timeForRemainingMessagesInSeconds);
            this._taskPendingSenderDisconnect.await(() -> {
                this._taskPendingSenderDisconnect = null;
                this.onClose();
            });
        } else {
            this.onClose();
        }
        this._eventOnDisconnected.fire(ex);
    }

    protected abstract void closeReceiverOnly();

    public void ensureFullyDisconnected() {
        if (this._taskPendingSenderDisconnect != null) {
            this._taskPendingSenderDisconnect.cancel();
            this._taskPendingSenderDisconnect = null;
            this.onClose();
        }
    }

    @Override
    public void disconnect(double timeForRemainingMessagesInSeconds) {
        if (!this.isConnected()) {
            throw new IllegalStateException("not connected");
        }
        this.internalDisconnect(null, timeForRemainingMessagesInSeconds);
    }
}

