/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network;

import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.network.ReceivingCallback;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ReceiverHelper {
    public final DataInputStream Stream;
    public final Dispatcher Dispatcher;
    public final BooleanSupplier IsActive;
    public volatile boolean Disconnecting = false;

    public ReceiverHelper(Dispatcher dispatcher, InputStream originalStream, BooleanSupplier isActive) {
        this.Stream = new DataInputStream(originalStream);
        this.Dispatcher = dispatcher;
        this.IsActive = isActive;
    }

    public void skip() throws IOException {
        MiscIO.skipBytes(this.Stream);
        throw new IOException("End of stream reached");
    }

    public void checkDisconnecting() throws IOException {
        if (this.Disconnecting) {
            this.skip();
        }
    }

    public void post(Runnable action) throws IOException {
        this.checkDisconnecting();
        this.Dispatcher.dispatch(() -> {
            if (this.IsActive.getAsBoolean()) {
                action.run();
            }
        });
    }

    public void postBlocking(Runnable action) throws IOException {
        this.checkDisconnecting();
        try {
            this.Dispatcher.dispatchCreateWaiter(() -> {
                if (this.IsActive.getAsBoolean()) {
                    action.run();
                }
            }).waitBlockingInterruptible();
            this.checkDisconnecting();
        }
        catch (InterruptedException e) {
            throw new IOException("postBlocking was interrupted", e);
        }
    }

    public <T> T getBlocking(Supplier<T> getter) throws IOException {
        this.checkDisconnecting();
        try {
            Object result = this.Dispatcher.dispatchCreateGetWaiter(() -> this.IsActive.getAsBoolean() ? getter.get() : null).waitBlockingInterruptible();
            this.checkDisconnecting();
            return (T)result;
        }
        catch (InterruptedException e) {
            throw new IOException("postBlocking was interrupted", e);
        }
    }

    public static ReceivingCallback toPackets(Consumer<byte[]> consumer) {
        return ReceiverHelper.toPackets(consumer, 1024);
    }

    public static ReceivingCallback toPackets(Consumer<byte[]> consumer, int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("BufferSize must be >0");
        }
        return rh -> {
            byte[] buffer = new byte[bufferSize];
            while (true) {
                rh.checkDisconnecting();
                int read = rh.Stream.read(buffer);
                if (read == -1) {
                    return;
                }
                byte[] msg = Arrays.copyOf(buffer, read);
                rh.post(() -> consumer.accept(msg));
            }
        };
    }
}

