/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.WrapException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MiscNet {
    private static final Object lockWarmup = new Object();
    private static boolean warmedUp;
    public static final Inet4Address BroadcastSendAddress;
    public static final Inet4Address BroadcastReceiveAddress;
    public static final Inet6Address IpV6AnyAddress;

    static {
        try {
            BroadcastSendAddress = (Inet4Address)InetAddress.getByAddress(new byte[]{-1, -1, -1, -1});
            BroadcastReceiveAddress = (Inet4Address)InetAddress.getByAddress(new byte[4]);
            IpV6AnyAddress = (Inet6Address)InetAddress.getByAddress(new byte[16]);
        }
        catch (UnknownHostException e) {
            throw new WrapException(e);
        }
    }

    private MiscNet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureNetworkingWarmupIsDone() {
        Object object = lockWarmup;
        synchronized (object) {
            if (warmedUp) {
                return;
            }
            warmedUp = true;
            Misc.runUninterruptable("Warmup Networking hack", () -> {
                try {
                    NetworkInterface.getNetworkInterfaces();
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                try {
                    Log.General.info("Warming up Socket & co.");
                    Throwable throwable = null;
                    Object var1_4 = null;
                    try (ServerSocket serverSocket = new ServerSocket();){
                        serverSocket.bind(null, 3);
                        Throwable throwable2 = null;
                        Object var4_9 = null;
                        try (Socket socket = new Socket();){
                            Misc.createCloseTimeout(socket, 0.1, true);
                            socket.connect(serverSocket.getLocalSocketAddress());
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    private static Stream<NetworkInterface> probableNetworkInterfaces(boolean mustSupportMulticast) throws SocketException {
        return MiscLINQ.stream(NetworkInterface.getNetworkInterfaces()).filter(x -> WrapException.enforce(() -> x.isUp() && !x.isLoopback() && (!mustSupportMulticast || x.supportsMulticast())));
    }

    public static List<NetworkInterface> getProbableNetworkInterfaces(boolean mustSupportMulticast) throws SocketException {
        try {
            return MiscNet.probableNetworkInterfaces(mustSupportMulticast).collect(Collectors.toList());
        }
        catch (WrapException e) {
            throw e.unwrap(SocketException.class);
        }
    }

    public static boolean trySetTcpNodelay(Socket socket, boolean value) {
        try {
            socket.setTcpNoDelay(value);
            return true;
        }
        catch (SocketException e) {
            Log.Developer.errorFull("Setting nodelay=" + value + " failed", e);
            return false;
        }
    }

    public static boolean tryDisableLinger(Socket socket) {
        try {
            socket.setSoLinger(false, 0);
            return true;
        }
        catch (SocketException e) {
            Log.Developer.errorFull("Setting linger=0 failed", e);
            return false;
        }
    }

    public static void setLowLatency(Socket socket) {
    }

    public static boolean trySetReuse(Socket socket, boolean reuse) {
        try {
            socket.setReuseAddress(reuse);
            return true;
        }
        catch (SocketException e) {
            Log.Developer.errorFull("Setting reuse=" + reuse + " failed", e);
            return false;
        }
    }
}

