/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.network.IpPort;
import com.iosoft.helpers.network.IpPortBase;

public final class IpPortOptional
extends IpPortBase {
    public final Character Port;

    public IpPortOptional(String ipAddress, Character port) {
        super(ipAddress);
        this.Port = port;
    }

    @Override
    public Character tryGetPort() {
        return this.Port;
    }

    public IpPort withPort() {
        if (this.Port == null) {
            throw new IllegalStateException("Record has no port");
        }
        return new IpPort(this.IpAddress, this.Port.charValue());
    }

    public IpPort withFallbackPort(char fallbackPort) {
        return new IpPort(this.IpAddress, this.Port == null ? fallbackPort : this.Port.charValue());
    }

    public static IpPortOptional tryParse(String str) {
        return IpPortOptional.tryParse(str, null);
    }

    public static IpPortOptional tryParse(String str, Character defaultPort) {
        boolean hasColon;
        if ((str = Misc.notNull(str).trim()).isEmpty()) {
            return null;
        }
        if (str.startsWith("[")) {
            int index = str.lastIndexOf(93);
            if (index == -1) {
                return new IpPortOptional(str.substring(1), defaultPort);
            }
            String ip = str.substring(1, index);
            if ((index = str.indexOf(58, index)) == -1) {
                return new IpPortOptional(ip, defaultPort);
            }
            return new IpPortOptional(ip, Misc.tryGetAsUShort(str.substring(index + 1)));
        }
        int lastColon = str.lastIndexOf(58);
        int firstColon = str.indexOf(58);
        boolean bl = hasColon = lastColon != -1;
        if (hasColon && lastColon != firstColon || !hasColon) {
            return new IpPortOptional(str, defaultPort);
        }
        Character possiblePort = Misc.tryGetAsUShort(str.substring(lastColon + 1));
        return new IpPortOptional(str.substring(0, lastColon), possiblePort == null ? defaultPort : possiblePort);
    }

    public static IpPortOptional parseDefaultLocalhost(String str, Character defaultPort) {
        IpPortOptional result = IpPortOptional.tryParse(str, defaultPort);
        if (result != null) {
            return result;
        }
        return new IpPortOptional("localhost", defaultPort);
    }
}

