/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network;

import com.iosoft.helpers.Misc;

public abstract class IpPortBase {
    public final String IpAddress;

    public IpPortBase(String ipAddress) {
        this.IpAddress = Misc.notNull(ipAddress).trim();
    }

    public final String toString() {
        boolean ipv6;
        Character maybePort = this.tryGetPort();
        if (maybePort == null) {
            return this.IpAddress;
        }
        char port = maybePort.charValue();
        boolean bl = ipv6 = this.IpAddress.indexOf(58) != -1;
        if (ipv6) {
            return "[" + this.IpAddress + "]:" + port;
        }
        return String.valueOf(this.IpAddress) + ":" + port;
    }

    public abstract Character tryGetPort();

    public char getPort(char fallback) {
        Character port = this.tryGetPort();
        return port == null ? fallback : port.charValue();
    }
}

