/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.network;

import com.iosoft.helpers.network.IpPortBase;
import com.iosoft.helpers.network.IpPortOptional;

public final class IpPort
extends IpPortBase {
    public final char Port;

    public IpPort(String ipAddress, char port) {
        super(ipAddress);
        this.Port = port;
    }

    @Override
    public Character tryGetPort() {
        return Character.valueOf(this.Port);
    }

    public IpPortOptional asOptional() {
        return new IpPortOptional(this.IpAddress, Character.valueOf(this.Port));
    }

    public static IpPort tryParse(String str) {
        IpPortOptional result = IpPortOptional.tryParse(str);
        return result == null || result.Port == null ? null : result.withPort();
    }

    public static IpPort tryParse(String str, char fallbackPort) {
        IpPortOptional result = IpPortOptional.tryParse(str, Character.valueOf(fallbackPort));
        return result == null ? null : result.withFallbackPort(fallbackPort);
    }

    public static IpPort parseDefaultLocalhost(String str, char fallbackPort) {
        return IpPortOptional.parseDefaultLocalhost(str, Character.valueOf(fallbackPort)).withFallbackPort(fallbackPort);
    }
}

