/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.math;

import com.iosoft.helpers.Misc;

public final class Vector2D {
    public static final double HeuristicSqrt2 = Math.sqrt(2.0);
    public static final double HeuristicDiagonalMultiplier = Math.sqrt(2.0) - 2.0;
    public static final Vector2D Zero = new Vector2D(0.0, 0.0);
    public static final Vector2D X1 = new Vector2D(1.0, 0.0);
    public static final Vector2D Y1 = new Vector2D(0.0, 1.0);
    public double X;
    public double Y;

    public Vector2D() {
        this.X = 0.0;
        this.Y = 0.0;
    }

    public Vector2D(double x, double y) {
        this.X = x;
        this.Y = y;
    }

    public Vector2D(Vector2D v) {
        this.X = v.X;
        this.Y = v.Y;
    }

    public Vector2D copy() {
        return new Vector2D(this);
    }

    public static Vector2D fromRot(double r, double distance) {
        return new Vector2D(Math.cos(r) * distance, Math.sin(r) * distance);
    }

    public void put(Vector2D v) {
        this.X = v.X;
        this.Y = v.Y;
    }

    public void put(double x, double y) {
        this.X = x;
        this.Y = y;
    }

    public void putFromRot(double r, double distance) {
        this.X = Math.cos(r) * distance;
        this.Y = Math.sin(r) * distance;
    }

    public void addSelfFromRot(double r, double distance) {
        this.X += Math.cos(r) * distance;
        this.Y += Math.sin(r) * distance;
    }

    public Vector2D addFromRot(double r, double distance) {
        Vector2D v = new Vector2D(this.X, this.Y);
        v.addSelfFromRot(r, distance);
        return v;
    }

    public double getLength() {
        return Math.sqrt(this.X * this.X + this.Y * this.Y);
    }

    public double getSqLength() {
        return this.X * this.X + this.Y * this.Y;
    }

    public double getDist(Vector2D v) {
        return this.getDist(v.X, v.Y);
    }

    public double getDist(double vx, double vy) {
        return Math.sqrt(this.getSqDist(vx, vy));
    }

    public double getSqDist(Vector2D v) {
        return this.getSqDist(v.X, v.Y);
    }

    public double getSqDist(double vx, double vy) {
        double dx = vx - this.X;
        double dy = vy - this.Y;
        return dx * dx + dy * dy;
    }

    public Vector2D add(Vector2D v) {
        return new Vector2D(this.X + v.X, this.Y + v.Y);
    }

    public Vector2D add(double x, double y) {
        return new Vector2D(this.X + x, this.Y + y);
    }

    public Vector2D addRotated(double x, double y, double rotation) {
        double cos = Math.cos(rotation);
        double sin = Math.sin(rotation);
        double dx = x;
        double dy = y;
        x = dx * cos - dy * sin;
        y = dx * sin + dy * cos;
        return new Vector2D(this.X + x, this.Y + y);
    }

    public Vector2D addRotated(Vector2D p, double rotation) {
        return this.addRotated(p.X, p.Y, rotation);
    }

    public void addSelf(Vector2D v) {
        this.X += v.X;
        this.Y += v.Y;
    }

    public void addSelf(double x, double y) {
        this.X += x;
        this.Y += y;
    }

    public Vector2D sub(Vector2D v) {
        return new Vector2D(this.X - v.X, this.Y - v.Y);
    }

    public Vector2D sub(double x, double y) {
        return new Vector2D(this.X - x, this.Y - y);
    }

    public void subSelf(double x, double y) {
        this.X -= x;
        this.Y -= y;
    }

    public void subSelf(Vector2D v) {
        this.X -= v.X;
        this.Y -= v.Y;
    }

    public Vector2D mul(double d) {
        return new Vector2D(this.X * d, this.Y * d);
    }

    public Vector2D mul(Vector2D v) {
        return new Vector2D(this.X * v.X, this.Y * v.Y);
    }

    public Vector2D mul(double _x, double _y) {
        return new Vector2D(this.X * _x, this.Y * _y);
    }

    public void mulSelf(double d) {
        this.X *= d;
        this.Y *= d;
    }

    public void mulSelf(double dx, double dy) {
        this.X *= dx;
        this.Y *= dy;
    }

    public void mulSelf(Vector2D v) {
        this.X *= v.X;
        this.Y *= v.Y;
    }

    public void divSelf(double d) {
        this.X /= d;
        this.Y /= d;
    }

    public Vector2D div(double d) {
        return new Vector2D(this.X / d, this.Y / d);
    }

    public double dot(Vector2D v) {
        return this.X * v.X + this.Y * v.Y;
    }

    public double cross(Vector2D v) {
        return this.X * v.Y - this.Y * v.X;
    }

    public Vector2D getOrtho() {
        return new Vector2D(-this.Y, this.X);
    }

    public Vector2D normalize() {
        return this.div(this.getLength());
    }

    public void normalizeSelf() {
        double l = this.getLength();
        if (l != 0.0) {
            this.X /= l;
            this.Y /= l;
        }
    }

    public void limitSelf(double maxLength) {
        double lenSq = this.getSqLength();
        if (lenSq != 0.0 && lenSq > maxLength * maxLength) {
            double w = maxLength / Math.sqrt(lenSq);
            this.X *= w;
            this.Y *= w;
        }
    }

    public void boostSelf(double minLength) {
        double lenSq = this.getSqLength();
        if (lenSq != 0.0 && lenSq < minLength * minLength) {
            double w = minLength / Math.sqrt(lenSq);
            this.X *= w;
            this.Y *= w;
        }
    }

    public void setLengthSelf(double length) {
        double lenSq = this.getSqLength();
        if (lenSq != 0.0) {
            double w = length / Math.sqrt(lenSq);
            this.X *= w;
            this.Y *= w;
        }
    }

    public double getCos(Vector2D v) {
        return this.dot(v) / Math.sqrt(this.getSqLength() * v.getSqLength());
    }

    public double getSin(Vector2D v) {
        return Math.sqrt(this.cross(v) / (this.getSqLength() * v.getSqLength()));
    }

    public double getAngle() {
        return Math.atan2(this.Y, this.X);
    }

    public double getAngle(Vector2D v) {
        return Math.atan2(v.Y - this.Y, v.X - this.X);
    }

    public double getAngle(double x, double y) {
        return Math.atan2(y - this.Y, x - this.X);
    }

    public String toString() {
        return "(" + this.X + "," + this.Y + ")";
    }

    public boolean equals(Object other) {
        return other instanceof Vector2D && this.equals((Vector2D)other);
    }

    public boolean equals(Vector2D other) {
        return this.X == other.X && this.Y == other.Y;
    }

    public int hashCode() {
        return Double.hashCode(this.X) * 31 + Double.hashCode(this.Y);
    }

    public Vector2D rotate(double rotation) {
        Vector2D newVec = new Vector2D(this.X, this.Y);
        newVec.rotateSelf(rotation);
        return newVec;
    }

    public Vector2D rotate(double rotation, double cX, double cY) {
        Vector2D v = new Vector2D(this.X - cX, this.Y - cY);
        v.rotateSelf(rotation);
        v.X += cX;
        v.Y += cY;
        return v;
    }

    public void rotateSelf(double rotation) {
        double cos = Math.cos(rotation);
        double sin = Math.sin(rotation);
        double dx = this.X;
        double dy = this.Y;
        this.X = dx * cos - dy * sin;
        this.Y = dx * sin + dy * cos;
    }

    public void rotateSelf(double rotation, double cX, double cY) {
        this.X -= cX;
        this.Y -= cY;
        this.rotateSelf(rotation);
        this.X += cX;
        this.Y += cY;
    }

    public boolean isInDistance(Vector2D pos, double radius) {
        double dx = pos.X - this.X;
        double dy = pos.Y - this.Y;
        if (dx > radius || dy > radius || dx < -radius || dy < -radius) {
            return false;
        }
        return radius * radius >= dx * dx + dy * dy;
    }

    public boolean isInDistance(Vector2D pos, double radius, double radiusSq) {
        double dx = pos.X - this.X;
        double dy = pos.Y - this.Y;
        if (dx > radius || dy > radius || dx < -radius || dy < -radius) {
            return false;
        }
        return radiusSq >= dx * dx + dy * dy;
    }

    public boolean mayBeInDistance(Vector2D pos, double radius) {
        double dx = pos.X - this.X;
        double dy = pos.Y - this.Y;
        return !(dx > radius || dy > radius || dx < -radius) && !(dy < -radius);
    }

    public double getTaxiDistance(Vector2D pos) {
        return Math.abs(this.X - pos.X) + Math.abs(this.Y - pos.Y);
    }

    public double getTaxiDistanceWithDiagonal(Vector2D pos, boolean diagonalSameCostAsCardinal) {
        double valX = Math.abs(this.X - pos.X);
        double valY = Math.abs(this.Y - pos.Y);
        double smaller = Math.min(valX, valY);
        return valX + valY + smaller * (diagonalSameCostAsCardinal ? -1.0 : HeuristicDiagonalMultiplier);
    }

    public void rotateSelf90DegreeSteps(int steps) {
        switch (Misc.modNegToPos(steps, 4)) {
            case 1: {
                double t = this.X;
                this.X = this.Y;
                this.Y = -t;
                return;
            }
            case 2: {
                double t = this.X;
                this.X = -this.Y;
                this.Y = t;
                return;
            }
            case 3: {
                this.X = -this.X;
                this.Y = -this.Y;
                return;
            }
        }
    }

    public boolean isNotZero() {
        return this.X != 0.0 || this.Y != 0.0;
    }
}

