/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.math;

import com.iosoft.helpers.math.CircleLineCollisionType;
import com.iosoft.helpers.math.Vector2D;

public final class CircleLineCollision {
    public Vector2D CircleCenter = new Vector2D();
    public double CircleRadius;
    public Vector2D LineStart = new Vector2D();
    public Vector2D LineDirection = new Vector2D();
    public Vector2D Pos1 = new Vector2D();
    public Vector2D Pos2 = new Vector2D();
    public double Discriminant;
    public CircleLineCollisionType CollisionType;
    public Double LineMin = 0.0;
    public Double LineMax;
    public double Line1;
    public double Line2;
    public boolean Pos1Ok;
    public boolean Pos2Ok;
    private final Vector2D _temp = new Vector2D();

    public void check() {
        double x1 = this.LineStart.X - this.CircleCenter.X;
        double y1 = this.LineStart.Y - this.CircleCenter.Y;
        double x2 = x1 + this.LineDirection.X;
        double y2 = y1 + this.LineDirection.Y;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dr2 = dx * dx + dy * dy;
        double D = x1 * y2 - x2 * y1;
        this.Discriminant = this.CircleRadius * this.CircleRadius * dr2 - D * D;
        if (this.Discriminant < 0.0) {
            this.CollisionType = CircleLineCollisionType.NoIntersection;
            this.Pos1Ok = false;
            this.Pos2Ok = false;
            return;
        }
        if (this.Discriminant == 0.0) {
            this.CollisionType = CircleLineCollisionType.Tangent;
            this.Pos1Ok = true;
            this.Pos2Ok = false;
            this.Pos1.X = D * dy / dr2 + this.CircleCenter.X;
            this.Pos1.Y = -D * dx / dr2 + this.CircleCenter.Y;
            return;
        }
        this.CollisionType = CircleLineCollisionType.Intersection;
        this.Pos1Ok = true;
        this.Pos2Ok = true;
        double discriminantSqrt = Math.sqrt(this.Discriminant);
        double sgnX = (dy < 0.0 ? -1.0 : 1.0) * dx * discriminantSqrt;
        double Dxy = D * dy;
        this.Pos1.X = (Dxy + sgnX) / dr2 + this.CircleCenter.X;
        this.Pos2.X = (Dxy - sgnX) / dr2 + this.CircleCenter.X;
        double sgnY = Math.abs(dy) * discriminantSqrt;
        double Dyx = -D * dx;
        this.Pos1.Y = (Dyx + sgnY) / dr2 + this.CircleCenter.Y;
        this.Pos2.Y = (Dyx - sgnY) / dr2 + this.CircleCenter.Y;
    }

    public void checkLines() {
        if (this.CollisionType == CircleLineCollisionType.NoIntersection) {
            return;
        }
        double unitLength = this.LineDirection.getLength();
        double rotation = this.LineDirection.getAngle();
        this._temp.put(this.Pos1);
        this._temp.subSelf(this.LineStart);
        this._temp.rotateSelf(-rotation);
        this.Line1 = this._temp.X / unitLength;
        if (this.Pos2Ok) {
            this._temp.put(this.Pos2);
            this._temp.subSelf(this.LineStart);
            this._temp.rotateSelf(-rotation);
            this.Line2 = this._temp.X / unitLength;
        }
        if (this.LineMin != null) {
            double lineMin = this.LineMin;
            if (this.Line1 < lineMin) {
                this.Pos1Ok = false;
            }
            if (this.Pos2Ok && this.Line2 < lineMin) {
                this.Pos2Ok = false;
            }
        }
        if (this.LineMax != null && (this.Pos1Ok || this.Pos2Ok)) {
            double lineMax = this.LineMax;
            if (this.Pos1Ok && this.Line1 > lineMax) {
                this.Pos1Ok = false;
            }
            if (this.Pos2Ok && this.Line2 > lineMax) {
                this.Pos2Ok = false;
            }
        }
    }

    public Vector2D getClosestPoint() {
        if (!this.Pos1Ok && !this.Pos2Ok) {
            throw new IllegalStateException("No intersection or tangent");
        }
        if (this.Pos1Ok != this.Pos2Ok) {
            return this.Pos1Ok ? this.Pos1 : this.Pos2;
        }
        return Math.abs(this.Line1) < Math.abs(this.Line2) ? this.Pos1 : this.Pos2;
    }
}

