/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.localizer.source;

import com.iosoft.helpers.FormatException;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.datasource.DataSourceUtil;
import com.iosoft.helpers.datasource.IDataSource;
import com.iosoft.helpers.localizer.source.AbstractLocalizationFile;
import com.iosoft.json.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JSONLocalizationFile
extends AbstractLocalizationFile {
    public JSONLocalizationFile(IDataSource source) {
        super(source);
    }

    @Override
    protected void loadFile(IDataSource source, Map<String, String> mapping) throws IOException {
        JSONLocalizationFile.addTexts(mapping, JSONLocalizationFile.loadJSON(source));
    }

    @Override
    protected Task<IOException> loadFileAsync(IDataSource source, Map<String, String> mapping) {
        return Async.runAsyncWrap(() -> JSONLocalizationFile.loadJSON(source)).awaitAndTranslate(x -> {
            if (x.Exception != null) {
                return (IOException)x.Exception;
            }
            JSONLocalizationFile.addTexts(mapping, (Map)x.Value);
            return null;
        });
    }

    private static Map<String, String> loadJSON(IDataSource source) throws IOException {
        try {
            JSON.Node root = JSON.deserialize(DataSourceUtil.loadAsString(source));
            HashMap<String, String> allTranslations = new HashMap<String, String>();
            JSONLocalizationFile.loadSubNodes("", root, allTranslations);
            return allTranslations;
        }
        catch (FormatException e) {
            throw new IOException("Could not load translation", e);
        }
    }

    private static void addTexts(Map<String, String> texts, Map<String, String> textsNew) {
        for (Map.Entry<String, String> entry : textsNew.entrySet()) {
            texts.put(entry.getKey(), entry.getValue());
        }
    }

    private static void load(String prefix, String key, JSON.Node node, Map<String, String> addTo) {
        JSON.NodeType nodeType = node.getType();
        if (nodeType == JSON.NodeType.STRING) {
            String name = String.valueOf(prefix) + key;
            addTo.put(name, (String)node.getValue());
        } else if (nodeType == JSON.NodeType.OBJECT) {
            prefix = String.valueOf(prefix) + key;
            JSONLocalizationFile.loadSubNodes(prefix, node, addTo);
        }
    }

    private static void loadSubNodes(String prefix, JSON.Node node, Map<String, String> addTo) {
        for (Map.Entry<String, JSON.Node> entry : node.getFields()) {
            JSONLocalizationFile.load(prefix, entry.getKey(), entry.getValue(), addTo);
        }
    }
}

