/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.localizer.source;

import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.datasource.IDataSource;
import com.iosoft.helpers.localizer.source.LocalizationSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractLocalizationFile
implements LocalizationSource {
    private boolean loaded = false;
    private final Map<String, String> mappings = new HashMap<String, String>();
    private final IDataSource source;

    public AbstractLocalizationFile(IDataSource source) {
        this.source = source;
    }

    protected abstract void loadFile(IDataSource var1, Map<String, String> var2) throws IOException;

    protected abstract Task<IOException> loadFileAsync(IDataSource var1, Map<String, String> var2);

    @Override
    public VTask loadAsync() {
        if (this.loaded) {
            return VTask.COMPLETED_TASK;
        }
        return this.loadFileAsync(this.source, this.mappings).awaitAndContinue(x -> {
            if (x != null) {
                throw new WrapException("couldn't load " + this.source.toString(), (Throwable)x);
            }
            this.loaded = true;
        });
    }

    @Override
    public void load() {
        if (this.loaded) {
            return;
        }
        try {
            this.loadFile(this.source, this.mappings);
            this.loaded = true;
        }
        catch (IOException ex) {
            throw new WrapException("couldn't load " + this.source.toString(), ex);
        }
    }

    @Override
    public void unload() {
        this.mappings.clear();
        this.loaded = false;
    }

    @Override
    public void addToTranslation(Map<String, String> existing) {
        existing.putAll(this.mappings);
    }
}

