/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.localizer;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Mutable;
import com.iosoft.helpers.binding.MyObservable;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.localizer.AbstractLocalizer;
import com.iosoft.helpers.localizer.Language;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Localizer
extends AbstractLocalizer
implements Iterable<Language> {
    private Language fallbackLanguage;
    private final List<Language> languages = new ArrayList<Language>();
    private final Map<String, String> localization = new HashMap<String, String>();
    private final MyObservable<Language> defaultLanguage = new MyObservable<Object>(null);
    public final Observable<Language> DefaultLanguage;

    public Localizer() {
        this.DefaultLanguage = this.defaultLanguage.Getter;
    }

    public Localizer(String fallbackLanguage) {
        this.DefaultLanguage = this.defaultLanguage.Getter;
        this.setFallbackLanguage(this.getOrCreateLanguage(fallbackLanguage));
    }

    @Override
    public String translateOrNull(String localizeCode) {
        return this.localization.get(localizeCode);
    }

    @Override
    public <T> T tryGetProperty(String name) {
        return this.DefaultLanguage.get().getProperty(name, null);
    }

    @Override
    public Locale getLocale() {
        return this.DefaultLanguage.get().getLocale();
    }

    public Language getOrCreateLanguage(String name) {
        Language language = this.tryGetLanguage(name);
        if (language != null) {
            return language;
        }
        return this.addLanguage(new Language(name));
    }

    public Language tryGetLanguage(String ... names) {
        Misc.notNull(names);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            for (Language language : this.languages) {
                if (!language.Name.equals(name)) continue;
                return language;
            }
            ++n2;
        }
        return null;
    }

    public boolean tryGetLanguage(Mutable<Language> mut, String ... names) {
        Misc.notNull(names);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            for (Language language : this.languages) {
                if (!language.Name.equals(name)) continue;
                mut.Value = language;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Language getLanguage(String name) {
        Misc.notNull(name);
        for (Language language : this.languages) {
            if (!language.Name.equals(name)) continue;
            return language;
        }
        throw new IllegalArgumentException("Language '" + name + "' not found");
    }

    private Language addLanguage(Language language) {
        this.languages.add(language);
        return language;
    }

    public Language getFallbackLanguage() {
        return this.fallbackLanguage;
    }

    public void setFallbackLanguage(Language fallback) {
        this.fallbackLanguage = fallback;
    }

    public void setDefaultLanguage(Language language) {
        Misc.notNull(language);
        Log.Developer.info("Setting '" + language.Name + "' as default language");
        if (!this.languages.contains(language)) {
            this.languages.add(language);
        }
        this.refreshLocalizations(language);
        this.defaultLanguage.set(language);
        this.fireLocalizationChanged();
    }

    void refreshLocalizations() {
        this.refreshLocalizations(this.DefaultLanguage.get());
        this.fireLocalizationChanged();
    }

    void refreshLocalizations(Language newDefaultLanguage) {
        this.localization.clear();
        if (this.fallbackLanguage != null && this.fallbackLanguage != newDefaultLanguage) {
            boolean wasLoaded = this.fallbackLanguage.isLoaded();
            if (!wasLoaded) {
                this.fallbackLanguage.load();
            }
            this.localization.putAll(this.fallbackLanguage.Localization);
            if (!wasLoaded) {
                this.fallbackLanguage.unload(false);
            }
        }
        if (newDefaultLanguage != null) {
            newDefaultLanguage.load();
            this.localization.putAll(newDefaultLanguage.Localization);
        }
    }

    @Override
    public Iterator<Language> iterator() {
        return this.languages.iterator();
    }

    public Language getClosestLanguageToSystemLanguage() {
        String iso2;
        String iso3;
        Mutable<Language> lang = new Mutable<Language>();
        Locale locale = Locale.getDefault();
        String bcp47 = locale.toLanguageTag();
        if (this.tryGetLanguage(lang, bcp47, iso3 = Misc.toLower(locale.getISO3Language()), iso2 = Misc.toLower(locale.getLanguage()), locale.getDisplayLanguage())) {
            return (Language)lang.Value;
        }
        String possibleStart = String.valueOf(iso2) + "-";
        for (Language language : this.languages) {
            if (!language.Name.startsWith(possibleStart)) continue;
            return language;
        }
        switch (iso3) {
            case "deu": {
                if (!this.tryGetLanguage(lang, "german")) break;
                return (Language)lang.Value;
            }
        }
        if (this.tryGetLanguage(lang, "english")) {
            return (Language)lang.Value;
        }
        return this.languages.isEmpty() ? null : this.languages.get(0);
    }

    public Language setDefaultLanguageBySystemLanguage() {
        Language language = this.getClosestLanguageToSystemLanguage();
        if (language != null) {
            this.setDefaultLanguage(language);
        }
        return language;
    }

    public Map<String, String> listCurrentTranslations() {
        return Collections.unmodifiableMap(this.localization);
    }
}

