/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.localizer;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.binding.Binding;
import com.iosoft.helpers.binding.MyObservable;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.localizer.ILocalizer;
import java.util.function.Consumer;

public class LocalizedString
implements IDisposable {
    private String _untranslatedText;
    private String _defaultText;
    private Object[] _args;
    private Binding<?> _binding;
    private final MyObservable<String> _translatedText = new MyObservable<String>("");
    private final ILocalizer _localizer;
    private final Runnable _registerHandle;
    public final Observable<String> Text;

    public LocalizedString(ILocalizer translator) {
        this(translator, "", new Object[0]);
    }

    public LocalizedString(ILocalizer translator, Observable<String> observable) {
        this(translator);
        this._binding = observable.bind(this::setText);
    }

    public LocalizedString(ILocalizer translator, String text, Object ... args) {
        this.Text = this._translatedText.Getter;
        this._localizer = translator;
        this._registerHandle = this::translate;
        translator.eventLocalizationChanged().register(this._registerHandle);
        this.set(text, args);
    }

    public LocalizedString(ILocalizer translator, String text, Consumer<String> setText) {
        this(translator, text, new Object[0]);
        this._binding = this.Text.bind(setText);
    }

    public LocalizedString(ILocalizer translator, String text, Consumer<String> setText, Object ... args) {
        this(translator, text, args);
        this._binding = this.Text.bind(setText);
    }

    public void set(String text, Object ... args) {
        this._untranslatedText = text;
        this.setArguments(args);
    }

    public void setText(String text) {
        this._untranslatedText = text;
        this.translate();
    }

    public void setTexts(String text, String defaultText) {
        this._untranslatedText = text;
        this.setDefaultText(defaultText);
    }

    public void setArguments(Object ... args) {
        this._args = args;
        this.translate();
    }

    public void setDefaultText(String text) {
        this._defaultText = text;
        this.translate();
    }

    public void translate() {
        String text = this._defaultText == null ? this._localizer.translate(this._untranslatedText, this._args) : this._localizer.translateOrFallback(this._untranslatedText, this._defaultText, this._args);
        this._translatedText.set(text);
    }

    @Override
    public void dispose() {
        this._localizer.eventLocalizationChanged().unregister(this._registerHandle);
        if (this._binding != null) {
            this._binding.dispose();
            this._binding = null;
        }
    }
}

