/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.iter;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class SkippingIterator<E>
implements Iterator<E> {
    private boolean nextEvaluated = false;
    private boolean nextExists = true;
    private E nextElement;

    private void goToNext() {
        if (this.nextEvaluated || !this.nextExists) {
            return;
        }
        this.nextEvaluated = true;
        this.nextElement = this.findNextElement();
    }

    protected void onEndReached() {
        this.nextExists = false;
    }

    protected abstract E findNextElement();

    @Override
    public boolean hasNext() {
        this.goToNext();
        return this.nextExists;
    }

    @Override
    public E next() {
        this.goToNext();
        if (!this.nextExists) {
            throw new NoSuchElementException();
        }
        E element = this.nextElement;
        this.nextEvaluated = false;
        return element;
    }

    protected void reset() {
        this.nextEvaluated = false;
        this.nextExists = true;
    }
}

