/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.io;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MutableBool;
import com.iosoft.helpers.ThrowingConsumer;
import com.iosoft.helpers.UnexpectedIOException;
import com.iosoft.helpers.math.Vector2D;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.UUID;

public final class MiscIO {
    private static final int PACKED_MASK_HAS_MORE = 128;
    private static final int PACKED_MASK_NUMBER = 127;
    private static final int PACKED_MAX_VALUE_5TH_BYTE_INT = 15;
    private static final byte[] _unimportantBuffer = new byte[1024];
    public static final String ForbiddenCharsInFilenames = "\\/:*?\"<>|";
    private static final char[] forbiddenCharsInFilenames = "\\/:*?\"<>|".toCharArray();

    private MiscIO() {
    }

    public static void writeUUID(DataOutput out, UUID uuid) throws IOException {
        out.writeLong(uuid.getMostSignificantBits());
        out.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUUID(DataInput in) throws IOException {
        return new UUID(in.readLong(), in.readLong());
    }

    public static String readCString(InputStream in, int maxchars) throws IOException {
        return Misc.bytesToString(MiscIO.readFully(in, maxchars));
    }

    public static void writeCString(OutputStream out, String str, int maxchars) throws IOException {
        out.write(Misc.cstringToBytes(str, maxchars));
    }

    public static void writeCString(OutputStream out, String str) throws IOException {
        MiscIO.writeCString(out, str, str.length());
    }

    public static String readString(InputStream in, int num) throws IOException {
        return new String(MiscIO.readFully(in, num), StandardCharsets.ISO_8859_1);
    }

    public static String readString(InputStream in) throws IOException {
        return MiscIO.readString(in, MiscIO.read(in));
    }

    public static void writeString(OutputStream out, String str) throws IOException {
        int length = str.length();
        if (length > 255) {
            str = str.substring(0, 255);
            length = 255;
        }
        out.write(length);
        out.write(str.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static void writeUTFString(OutputStream out, String str) throws IOException {
        byte[] buffer = str.getBytes(StandardCharsets.UTF_8);
        int length = Math.min(255, buffer.length);
        out.write(length);
        out.write(buffer, 0, length);
    }

    public static String readUTFString(InputStream in) throws IOException {
        return new String(MiscIO.readFully(in, MiscIO.read(in)), StandardCharsets.UTF_8);
    }

    public static int read(InputStream in) throws IOException {
        int val = in.read();
        if (val == -1) {
            throw new EOFException("End of stream reached");
        }
        return val;
    }

    public static void readFully(InputStream in, byte[] buffer) throws IOException {
        MiscIO.readFully(in, buffer, 0, buffer.length);
    }

    /*
     * Unable to fully structure code
     */
    public static void readFully(InputStream in, byte[] buffer, int off, int len) throws IOException {
        block2: {
            if (!(in instanceof DataInputStream)) ** GOTO lbl9
            ((DataInputStream)in).readFully(buffer, off, len);
            break block2;
lbl-1000:
            // 1 sources

            {
                read = in.read(buffer, off, len);
                if (read == -1) {
                    throw new EOFException("End of stream reached");
                }
                off += read;
                len -= read;
lbl9:
                // 2 sources

                ** while (len > 0)
            }
        }
    }

    public static byte[] readFully(DataInputStream in, int bufferSize) throws IOException {
        return MiscIO.readFully((DataInput)in, bufferSize);
    }

    public static byte[] readFully(DataInput in, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        in.readFully(buffer);
        return buffer;
    }

    public static byte[] readFully(InputStream in, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        MiscIO.readFully(in, buffer);
        return buffer;
    }

    public static byte[] readFully(InputStream in) throws IOException {
        Misc.notNull(in);
        int available = in.available();
        int bufferSize = Math.max(available, 65536);
        byte[] buffer = new byte[bufferSize];
        Throwable throwable = null;
        Object var5_6 = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(available);){
            while (true) {
                int read;
                if ((read = in.read(buffer, 0, bufferSize)) == -1) {
                    return baos.toByteArray();
                }
                baos.write(buffer, 0, read);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static int readPackedBools(InputStream in, boolean[] readInto, int[] truesInto) throws IOException {
        int offset = 0;
        int numUpdates = 0;
        int length = readInto.length;
        do {
            int remainingBits = length - offset;
            Misc.readByte(MiscIO.read(in), readInto, offset, remainingBits > 7 ? 8 : remainingBits);
            int iC = remainingBits > 8 ? 7 : remainingBits;
            int i = 0;
            while (i < iC) {
                if (readInto[offset]) {
                    truesInto[numUpdates] = offset;
                    ++numUpdates;
                }
                ++offset;
                ++i;
            }
        } while (offset < length && readInto[offset]);
        return numUpdates;
    }

    public static int writePackedBools(OutputStream out, boolean[] bools) throws IOException {
        return MiscIO.writePackedBools(out, bools, bools.length);
    }

    public static int writePackedBools(OutputStream out, boolean[] bools, int length) throws IOException {
        int remainingBits;
        int maxNumberOfBits = 0;
        int i = length - 1;
        while (i >= 0) {
            if (bools[i]) {
                maxNumberOfBits = i + 1;
                break;
            }
            --i;
        }
        int offset = 0;
        while (true) {
            if ((remainingBits = maxNumberOfBits - offset) < 8 || length - offset < 9) break;
            out.write(Misc.buildByte(bools, offset, 7) | 0x80);
            offset += 7;
        }
        out.write(Byte.toUnsignedInt(Misc.buildByte(bools, offset, remainingBits)));
        return maxNumberOfBits;
    }

    public static void writePackedUInt(OutputStream out, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException("out of range: " + value);
        }
        MiscIO.writePacked(out, value);
    }

    public static int readPackedUInt(InputStream in) throws IOException {
        int value = MiscIO.readPacked(in);
        if (value < 0) {
            throw new IOException("invalid value for an UInt: " + value);
        }
        return value;
    }

    public static void writePackedInt(OutputStream out, int value) throws IOException {
        MiscIO.writePacked(out, MiscIO.transformRawIntToPacked(value));
    }

    public static int readPackedInt(InputStream in) throws IOException {
        return MiscIO.transformPackedToRawInt(MiscIO.readPacked(in));
    }

    public static void writePacked(OutputStream out, int value) throws IOException {
        do {
            int write = value & 0x7F;
            if ((value >>>= 7) != 0) {
                write |= 0x80;
            }
            out.write(write);
        } while (value != 0);
    }

    public static void writePacked2(OutputStream out, long value) throws IOException {
        int bytesWritten = 0;
        do {
            if (bytesWritten == 8) {
                out.write((int)value);
                break;
            }
            int write = (int)(value & 0x7FL);
            if ((value >>>= 7) != 0L) {
                write |= 0x80;
            }
            out.write(write);
            ++bytesWritten;
        } while (value != 0L);
    }

    public static int readPacked(InputStream in) throws IOException {
        int read;
        int value = 0;
        int bitOffset = 0;
        do {
            read = MiscIO.read(in);
            if (bitOffset == 28 && read > 15) {
                throw new IOException("Cannot read packed: " + bitOffset + ", " + read + ", " + value);
            }
            value |= (read & 0x7F) << bitOffset;
        } while ((bitOffset += 7) < 32 && (read & 0x80) != 0);
        return value;
    }

    public static long readPacked2(InputStream in) throws IOException {
        int read;
        long value = 0L;
        int bitOffset = 0;
        do {
            read = MiscIO.read(in);
            if (bitOffset >= 56) {
                value += (long)read << bitOffset;
                break;
            }
            value |= (long)(read & 0x7F) << bitOffset;
            bitOffset += 7;
        } while ((read & 0x80) != 0);
        return value;
    }

    public static int transformRawIntToPacked(int value) {
        if (value >= 0) {
            return value << 1 | 1;
        }
        value ^= 0xFFFFFFFF;
        return value <<= 1;
    }

    public static int transformPackedToRawInt(int value) {
        if ((value & 1) == 1) {
            return value >>> 1;
        }
        value >>>= 1;
        return value ^= 0xFFFFFFFF;
    }

    public static byte[] readStream(InputStream in, int bufferSize) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(bufferSize);){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (BufferedInputStream bis = new BufferedInputStream(in);){
                int readBytes;
                byte[] bytes = new byte[bufferSize];
                while ((readBytes = bis.read(bytes)) > 0) {
                    out.write(bytes, 0, readBytes);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            return out.toByteArray();
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static InputStream getResource(String path) throws FileNotFoundException {
        InputStream in = Misc.class.getResourceAsStream(path);
        if (in == null) {
            throw new FileNotFoundException("Resource '" + path + "' was not found");
        }
        return in;
    }

    /*
     * Unable to fully structure code
     */
    public static void skipBytes(InputStream in, long number) throws IOException {
        block3: {
            buffer = MiscIO._unimportantBuffer;
            BUFLEN = MiscIO._unimportantBuffer.length;
            if (number != -1L) ** GOTO lbl13
            do {
                if ((read = in.read(buffer)) >= 0) continue;
                throw new EOFException("End of stream reached");
            } while (read > 0);
            break block3;
lbl-1000:
            // 1 sources

            {
                read = number < (long)BUFLEN ? (int)number : BUFLEN;
                if ((read = in.read(buffer, 0, read)) < 0) {
                    throw new EOFException("End of stream reached");
                }
                number -= (long)read;
lbl13:
                // 2 sources

                ** while (number > 0L)
            }
        }
    }

    public static void skipBytes(InputStream in) throws IOException {
        MiscIO.skipBytes(in, -1L);
    }

    /*
     * Unable to fully structure code
     */
    public static void skipFully(DataInput in, int num) throws IOException {
        if (num != -1) ** GOTO lbl8
        while (true) {
            in.readFully(MiscIO._unimportantBuffer);
        }
lbl-1000:
        // 1 sources

        {
            readNum = Math.min(MiscIO._unimportantBuffer.length, num);
            in.readFully(MiscIO._unimportantBuffer, 0, readNum);
            num -= readNum;
lbl8:
            // 2 sources

            ** while (num > 0)
        }
lbl9:
        // 1 sources

    }

    public static void writeChars(DataOutput out, String str, int len) throws IOException {
        out.writeChars(MiscIO.prepareChars(str, len));
    }

    public static String prepareChars(String str, int len) {
        return Misc.padRight(Misc.limitLength(str, len), len, '\u0000');
    }

    public static String readChars(DataInput in, int num) throws IOException {
        StringBuilder sb = new StringBuilder(num);
        while (num > 0) {
            --num;
            char c = in.readChar();
            if (c == '\u0000') {
                MiscIO.skipFully(in, num * 2);
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean resourceExists(String path) {
        InputStream in = Misc.class.getResourceAsStream(path);
        if (in == null) {
            return false;
        }
        Misc.forceClose(in);
        return true;
    }

    public static String readText(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
    }

    public static void writeText(File file, String text) throws IOException {
        Files.write(file.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static String getResourceAsString(String res) throws IOException {
        byte[] buffer;
        Throwable throwable = null;
        Object var3_3 = null;
        try (InputStream in = MiscIO.getResource(res);){
            buffer = MiscIO.readFully(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new String(buffer, StandardCharsets.UTF_8);
    }

    public static ArrayList<String> getResourceAsStrings(String res) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream in = MiscIO.getResource(res);){
            return MiscIO.getStreamAsStrings(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayList<String> getStreamAsStrings(InputStream in) throws IOException {
        return MiscIO.getStreamAsStrings(in, StandardCharsets.UTF_8);
    }

    public static ArrayList<String> getStreamAsStrings(InputStream in, Charset charset) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = MiscIO.openReader(in, charset);){
            String line;
            ArrayList<String> strings = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                strings.add(line);
            }
            return strings;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static BufferedReader openUTF8Reader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public static BufferedReader openUTF8Reader(File file) throws FileNotFoundException {
        return MiscIO.openUTF8Reader(new FileInputStream(file));
    }

    public static BufferedReader openReader(InputStream in, Charset charset) {
        return new BufferedReader(new InputStreamReader(in, charset));
    }

    public static BufferedWriter openUTF8Writer(File file) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    public static int getInt(InputStream in) throws IOException {
        return MiscIO.getInt(in, 4);
    }

    public static int getInt(InputStream in, int max) throws IOException {
        return Misc.extractInt(MiscIO.readFully(in, max), 0, max);
    }

    public static long getLong(InputStream in) throws IOException {
        return MiscIO.getLong(in, 8);
    }

    public static long getLong(InputStream in, int max) throws IOException {
        return Misc.extractLong(MiscIO.readFully(in, max), 0, max);
    }

    public static float getFloat(InputStream in) throws IOException {
        return MiscIO.getFloat(in, 4);
    }

    public static float getFloat(InputStream in, int max) throws IOException {
        return Misc.extractFloat(MiscIO.readFully(in, max), 0, max);
    }

    public static double getDouble(InputStream in) throws IOException {
        return MiscIO.getDouble(in, 8);
    }

    public static double getDouble(InputStream in, int max) throws IOException {
        return Misc.extractDouble(MiscIO.readFully(in, max), 0, max);
    }

    public static String getExtension(File file) {
        return MiscIO.getExtension(file.getName(), "");
    }

    public static String getExtension(String fileName) {
        return MiscIO.getExtension(fileName, "");
    }

    public static String getExtension(File file, String defaultValue) {
        return MiscIO.getExtension(file.getName(), defaultValue);
    }

    public static String getExtension(String fileName, String defaultValue) {
        int index = fileName.lastIndexOf(46);
        return index == -1 ? defaultValue : Misc.toUpper(fileName.substring(index + 1));
    }

    public static String getExtensionSafe(File file, String defaultValue) {
        return MiscIO.getExtensionSafe(file.getName(), defaultValue);
    }

    public static String getExtensionSafe(String fileName, String defaultValue) {
        String extension = Misc.limitLength(MiscIO.getExtension(fileName, defaultValue), 10);
        int i = 0;
        int iC = extension.length();
        while (i < iC) {
            char c = extension.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                return defaultValue;
            }
            ++i;
        }
        return extension;
    }

    public static String getWithoutExtension(File file) {
        return MiscIO.getWithoutExtension(file.getName());
    }

    public static String getWithoutExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        return index == -1 ? fileName : fileName.substring(0, index);
    }

    public static boolean isValidFileName(String value, boolean dotIsBad) {
        if (dotIsBad && value.contains(".")) {
            return false;
        }
        char[] cArray = forbiddenCharsInFilenames;
        int n = forbiddenCharsInFilenames.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (value.contains("" + ch)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String sanitizeFileName(String fileName, boolean dotIsBad) {
        if (dotIsBad) {
            fileName = fileName.replace('.', '_');
        }
        char[] cArray = forbiddenCharsInFilenames;
        int n = forbiddenCharsInFilenames.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            fileName = fileName.replace(ch, '_');
            ++n2;
        }
        return fileName;
    }

    public static File sanitizeFileName(File file) {
        return MiscIO.sanitizeFileName(file, MutableBool.Dummy);
    }

    public static File sanitizeFileName(File file, MutableBool hadQuotes) {
        boolean foundSomething;
        String filename = file.getName();
        do {
            filename = filename.trim();
            foundSomething = false;
            if (filename.startsWith("\"")) {
                hadQuotes.Value = true;
                filename = filename.substring(1);
                foundSomething = true;
            }
            if (!filename.endsWith("\"")) continue;
            hadQuotes.Value = true;
            filename = filename.substring(0, filename.length() - 1);
            foundSomething = true;
        } while (foundSomething);
        File parent = file.getParentFile();
        if (parent == null) {
            return new File(filename);
        }
        return new File(parent, filename);
    }

    public static void forceDelete(File f) throws IOException {
        File[] files;
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                try {
                    MiscIO.forceDelete(c);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Couldn't delete " + f);
        }
    }

    public static void mkdirs(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Couldn't create path to '" + directory.getAbsolutePath() + "'");
        }
    }

    public static <T> T readByte(DataInput in, T[] values) throws IOException {
        int index = in.readUnsignedByte();
        if (index >= values.length) {
            throw new UnexpectedIOException("Invalid " + (values.length > 0 ? values[0].getClass().getSimpleName() : "value") + " (" + index + ")");
        }
        return values[index];
    }

    public static void writeByte(DataOutput out, Enum<?> value) throws IOException {
        int ordinal = value.ordinal();
        if (ordinal < 0 || ordinal > 255) {
            throw new IllegalArgumentException("Not a byte (" + ordinal + ", " + value + ")");
        }
        out.write(ordinal);
    }

    public static double readFiniteDouble(DataInput in) throws IOException {
        double value = in.readDouble();
        if (!Double.isFinite(value)) {
            throw new UnexpectedIOException("Invalid double: " + value);
        }
        return value;
    }

    public static float readFiniteFloat(DataInput in) throws IOException {
        float value = in.readFloat();
        if (!Float.isFinite(value)) {
            throw new UnexpectedIOException("Invalid float: " + value);
        }
        return value;
    }

    public static void writeFiniteDouble(DataOutput out, double value) throws IOException {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException("Invalid double: " + value);
        }
        out.writeDouble(value);
    }

    public static void writeFiniteFloat(DataOutput out, float value) throws IOException {
        if (!Float.isFinite(value)) {
            throw new IllegalArgumentException("Invalid float: " + value);
        }
        out.writeFloat(value);
    }

    public static void writeLEShort(OutputStream out, int value) throws IOException {
        out.write(value);
        out.write(value >> 8);
    }

    public static Point readPointShort(DataInput in) throws IOException {
        Point point = new Point();
        MiscIO.readPointShort(in, point);
        return point;
    }

    public static void readPointShort(DataInput in, Point point) throws IOException {
        point.x = in.readShort();
        point.y = in.readShort();
    }

    public static void writePointShort(DataOutput out, Point point) throws IOException {
        out.writeShort(point.x);
        out.writeShort(point.y);
    }

    public static Point readPointUByte(DataInput in) throws IOException {
        Point point = new Point();
        MiscIO.readPointUByte(in, point);
        return point;
    }

    public static void readPointUByte(DataInput in, Point point) throws IOException {
        point.x = in.readUnsignedByte();
        point.y = in.readUnsignedByte();
    }

    public static void writePointUByte(DataOutput out, Point point) throws IOException {
        out.write(MiscIO.ensureNotNegative(point.x));
        out.write(MiscIO.ensureNotNegative(point.y));
    }

    public static Point readPointUShort(DataInput in) throws IOException {
        Point point = new Point();
        MiscIO.readPointUShort(in, point);
        return point;
    }

    public static void readPointUShort(DataInput in, Point point) throws IOException {
        point.x = in.readUnsignedShort();
        point.y = in.readUnsignedShort();
    }

    public static void writePointUShort(DataOutput out, Point point) throws IOException {
        out.writeShort(MiscIO.ensureNotNegative(point.x));
        out.writeShort(MiscIO.ensureNotNegative(point.y));
    }

    public static Dimension readSizeShort(DataInput in) throws IOException {
        Dimension size = new Dimension();
        MiscIO.readSizeShort(in, size);
        return size;
    }

    public static void readSizeShort(DataInput in, Dimension size) throws IOException {
        size.width = in.readShort();
        size.height = in.readShort();
    }

    public static void writeSizeShort(DataOutput out, Dimension size) throws IOException {
        out.writeShort(size.width);
        out.writeShort(size.height);
    }

    public static Dimension readSizeUShort(DataInput in) throws IOException {
        Dimension size = new Dimension();
        MiscIO.readSizeUShort(in, size);
        return size;
    }

    public static void readSizeUShort(DataInput in, Dimension size) throws IOException {
        size.width = in.readChar();
        size.height = in.readChar();
    }

    public static void writeSizeUShort(DataOutput out, Dimension size) throws IOException {
        out.writeChar(MiscIO.ensureNotNegative(size.width));
        out.writeChar(MiscIO.ensureNotNegative(size.height));
    }

    public static int ensureNotNegative(int number) throws UnexpectedIOException {
        if (number < 0) {
            throw new UnexpectedIOException("Using unsigned but is negative (" + number + ")");
        }
        return number;
    }

    public static void readVector2DDouble(DataInput in, Vector2D vec) throws IOException {
        vec.X = MiscIO.readFiniteDouble(in);
        vec.Y = MiscIO.readFiniteDouble(in);
    }

    public static void writeVector2DDouble(DataOutput out, Vector2D vec) throws IOException {
        MiscIO.writeFiniteDouble(out, vec.X);
        MiscIO.writeFiniteDouble(out, vec.Y);
    }

    public static void readVector2DFloat(DataInput in, Vector2D vec) throws IOException {
        vec.X = MiscIO.readFiniteFloat(in);
        vec.Y = MiscIO.readFiniteFloat(in);
    }

    public static void writeVector2DFloat(DataOutput out, Vector2D vec) throws IOException {
        MiscIO.writeFiniteFloat(out, (float)vec.X);
        MiscIO.writeFiniteFloat(out, (float)vec.Y);
    }

    public static double read1ByteProgress(DataInput in) throws IOException {
        return (double)in.readUnsignedByte() / 255.0;
    }

    public static void write1ByteProgress(DataOutput out, double progress) throws IOException {
        out.writeByte(Misc.clamp((int)(progress * 255.0), 0, 255));
    }

    public static double read1ByteProgressNo1(DataInput in) throws IOException {
        return (double)in.readUnsignedByte() / 256.0;
    }

    public static void write1ByteProgressNo1(DataOutput out, double progress) throws IOException {
        out.writeByte(Misc.clamp((int)(progress * 256.0), 0, 255));
    }

    public static <E extends Throwable> byte[] toByteArray(ThrowingConsumer<OutputStream, E> writer) throws E {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.accept(baos);
        return baos.toByteArray();
    }
}

