/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.io;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.io.MiscIO;
import java.awt.Point;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public interface BitDataOutput
extends DataOutput {
    public void writeBits(int var1, int var2) throws IOException;

    public void writePackedUInt(int var1) throws IOException;

    public void writePackedInt(int var1) throws IOException;

    public void writePackedBits(int var1) throws IOException;

    public void writePackedBits(long var1, int var3) throws IOException;

    public void align() throws IOException;

    public void ensureAligned();

    public void writeFiniteDouble(double var1) throws IOException;

    public void writeFiniteFloat(float var1) throws IOException;

    default public void writeChars(String string, int length) throws IOException {
        this.writeChars(MiscIO.prepareChars(string, length));
    }

    default public void writeUTFString(String s) throws IOException {
        byte[] buffer = s.getBytes(StandardCharsets.UTF_8);
        if (buffer.length > 255) {
            throw new IOException("String too long ('" + s.substring(0, 20) + "...')");
        }
        this.writeByte(buffer.length);
        this.write(buffer);
    }

    default public void writeCString(String string) throws IOException {
        this.writeCString(string, string.length());
    }

    default public void writeCString(String string, int maxChars) throws IOException {
        this.write(Misc.cstringToBytes(string, maxChars));
    }

    default public void writePointShort(Point point) throws IOException {
        this.align();
        MiscIO.writePointShort(this, point);
    }
}

