/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.game;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.web.MiscWeb;
import java.util.Arrays;

public final class UpdateChecker {
    private UpdateChecker() {
    }

    public static Task<Result> checkForUpdatesAsync(String url, String signature, String myVersion) {
        return MiscWeb.getFirstLineAsync(url, 10240).awaitAndTranslate(response -> {
            String[] split;
            Result result = new Result();
            String line = response.tryGetFirstLine();
            if (line != null && (split = line.split("\t", -1)).length >= 2 && split[0].equals(signature)) {
                String foundVersion = split[1];
                Log.App.info("UpdateChecker: Most recent version: " + foundVersion);
                result.Successful = true;
                result.Version = split[1];
                result.HasNewVersion = !foundVersion.equals(myVersion);
                result.OtherData = String.join((CharSequence)"\t", Arrays.copyOfRange(split, 2, split.length));
            }
            return result;
        });
    }

    public static class Result {
        public boolean Successful;
        public boolean HasNewVersion;
        public String Version;
        public String OtherData;
    }
}

