/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.game;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.datasource.IDataSource;
import com.iosoft.helpers.io.MiscIO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class SavegameStreams {
    private final byte[] _prefix;
    public boolean WritePlain = false;
    public boolean WritePlainPlatform = false;

    public SavegameStreams(String prefix) {
        this(prefix.getBytes(StandardCharsets.UTF_8));
    }

    public SavegameStreams(byte[] prefix) {
        this._prefix = Misc.notNull(prefix);
    }

    public InputStream getInputStream(InputStream in) throws IOException {
        ZipEntry zipEntry;
        boolean isPlain;
        byte[] prefix = MiscIO.readFully(in, this._prefix.length);
        if (!Arrays.equals(prefix, this._prefix)) {
            throw new IOException("Prefix does not match");
        }
        int version = MiscIO.read(in);
        boolean isR = version == 13;
        boolean bl = isPlain = isR || version == 10;
        if (isPlain) {
            if (isR) {
                MiscIO.read(in);
            }
            return in;
        }
        ConfuseInputStream cis = new ConfuseInputStream(in);
        ZipInputStream zis = new ZipInputStream(cis);
        try {
            zipEntry = zis.getNextEntry();
        }
        catch (Exception e) {
            Misc.forceClose(zis);
            throw e;
        }
        if (zipEntry == null) {
            zis.close();
            throw new IOException("Data not found");
        }
        return zis;
    }

    public InputStream getInputStream(IDataSource dataSource) throws IOException {
        return this.getInputStream(dataSource.openBufferedStream());
    }

    public byte[] serialize(byte[] input) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream out = this.getOutputStream(baos);){
                out.write(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        return baos.toByteArray();
    }

    public byte[] deserialize(byte[] input) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = this.getInputStream(bais);){
            return MiscIO.readFully(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public OutputStream getOutputStream(OutputStream out) throws IOException {
        out.write(this._prefix);
        if (this.WritePlain) {
            if (this.WritePlainPlatform && Misc.IsOnWindows) {
                out.write(13);
            }
            out.write(10);
            return out;
        }
        out.write(0);
        ConfuseOutputStream cos = new ConfuseOutputStream(out);
        final ZipOutputStream zos = new ZipOutputStream(cos);
        try {
            zos.putNextEntry(new ZipEntry(""));
        }
        catch (Exception e) {
            Misc.forceClose(zos);
            throw e;
        }
        return new FilterOutputStream(zos){

            @Override
            public void close() throws IOException {
                try {
                    zos.closeEntry();
                }
                finally {
                    super.close();
                }
            }
        };
    }

    public OutputStream getOutputStream(File file) throws IOException {
        return this.getOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: first parameter prefix, other parameters files to convert");
            return;
        }
        SavegameStreams savegameStreams = new SavegameStreams(args[0]);
        savegameStreams.WritePlain = true;
        boolean ignoreFirst = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (true) {
            block46: {
                if (n2 >= n) {
                    return;
                }
                String filename = stringArray[n2];
                if (!ignoreFirst) {
                    ignoreFirst = true;
                } else {
                    try {
                        byte[] fileInMemory;
                        Object var9_12;
                        Throwable throwable;
                        block43: {
                            throwable = null;
                            var9_12 = null;
                            try {
                                FileInputStream fis = new FileInputStream(filename);
                                try {
                                    block42: {
                                        BufferedInputStream bis = new BufferedInputStream(fis);
                                        try {
                                            try (InputStream in = savegameStreams.getInputStream(bis);){
                                                fileInMemory = MiscIO.readFully(in);
                                            }
                                            if (bis == null) break block42;
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                            } else if (throwable != throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            if (bis == null) throw throwable;
                                            bis.close();
                                            throw throwable;
                                        }
                                        bis.close();
                                    }
                                    if (fis == null) break block43;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    if (fis == null) throw throwable;
                                    fis.close();
                                    throw throwable;
                                }
                                fis.close();
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                    throw throwable;
                                }
                                if (throwable == throwable4) throw throwable;
                                throwable.addSuppressed(throwable4);
                                throw throwable;
                            }
                        }
                        throwable = null;
                        var9_12 = null;
                        try {
                            FileOutputStream fos = new FileOutputStream(String.valueOf(filename) + "_plain");
                            try {
                                block45: {
                                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                                    try {
                                        try (OutputStream out = savegameStreams.getOutputStream(bos);){
                                            out.write(fileInMemory);
                                        }
                                        if (bos == null) break block45;
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable == null) {
                                            throwable = throwable5;
                                        } else if (throwable != throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                        if (bos == null) throw throwable;
                                        bos.close();
                                        throw throwable;
                                    }
                                    bos.close();
                                }
                                if (fos == null) break block46;
                            }
                            catch (Throwable throwable6) {
                                if (throwable == null) {
                                    throwable = throwable6;
                                } else if (throwable != throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                if (fos == null) throw throwable;
                                fos.close();
                                throw throwable;
                            }
                            fos.close();
                        }
                        catch (Throwable throwable7) {
                            if (throwable == null) {
                                throwable = throwable7;
                                throw throwable;
                            }
                            if (throwable == throwable7) throw throwable;
                            throwable.addSuppressed(throwable7);
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Error converting '" + filename + "': " + Misc.printExceptionShort(e));
                    }
                }
            }
            ++n2;
        }
    }

    public static class ConfuseInputStream
    extends FilterInputStream {
        public ConfuseInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int read = this.in.read();
            if (read == -1) {
                return -1;
            }
            return ~read & 0xFF;
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.in.read(b, off, len);
            if (read == -1) {
                return -1;
            }
            int i = 0;
            while (i < read) {
                b[off + i] = (byte)(~b[off + i] & 0xFF);
                ++i;
            }
            return read;
        }
    }

    public static class ConfuseOutputStream
    extends FilterOutputStream {
        private byte[] buffer = new byte[10];

        public ConfuseOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int i) throws IOException {
            this.out.write(~i);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.buffer.length < len) {
                int oldLength = this.buffer.length;
                this.buffer = null;
                if (oldLength > 512000) {
                    Runtime.getRuntime().gc();
                }
                this.buffer = new byte[len];
            }
            int i = 0;
            while (i < len) {
                this.buffer[i] = (byte)(~b[off + i] & 0xFF);
                ++i;
            }
            this.out.write(this.buffer, 0, len);
        }
    }
}

