/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.game;

import com.iosoft.helpers.Misc;
import java.util.Iterator;

public final class RandomIterator<T>
implements Iterator<T> {
    private int _iC;
    private int _offset;
    private int _i;
    private T[] _values;
    private boolean _backwards;

    public RandomIterator(T[] values) {
        this(values, Misc.getRandomInt(values.length), Misc.randomBool());
    }

    public RandomIterator(T[] values, int offset, boolean backwards) {
        this.reuse(values, offset, backwards);
    }

    public void reuse(T[] values) {
        this.reuse(values, Misc.getRandomInt(values.length), Misc.randomBool());
    }

    public void reuse(T[] values, int offset, boolean backwards) {
        this._values = values;
        this._iC = this._values.length;
        this.reset(offset, backwards);
    }

    public void reset() {
        this.reset(Misc.getRandomInt(this._values.length), Misc.randomBool());
    }

    public void reset(int offset, boolean backwards) {
        this._offset = offset;
        this._backwards = backwards;
        this._i = 0;
    }

    @Override
    public boolean hasNext() {
        return this._i < this._iC;
    }

    @Override
    public T next() {
        ++this._i;
        int index = (this._i + this._offset) % this._iC;
        return this._values[this._backwards ? this._iC - index - 1 : index];
    }
}

