/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.game;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.game.Handleable;
import com.iosoft.helpers.game.ObjectHandle;
import com.iosoft.helpers.game.ObjectHandleResolver;
import com.iosoft.helpers.game.Resolvable;
import com.iosoft.helpers.iter.SkippingIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class ObjectList<T extends Handleable>
implements Iterable<T>,
Resolvable {
    private final List<ObjectHandle<T>> list = new LinkedList<ObjectHandle<T>>();

    public void add(ObjectHandle<T> o) {
        T obj = o.getObj();
        if (obj != null) {
            this.addObject(obj);
        }
    }

    public boolean add(T e) {
        if (e != null) {
            return this.addObject(e);
        }
        return false;
    }

    public void addRange(Iterable<T> range) {
        for (Handleable e : range) {
            if (e == null) continue;
            this.addObject(e);
        }
    }

    protected boolean addObject(T e) {
        ObjectHandle<T> hndl;
        Misc.notNull(e);
        if (e.exists() && !this.contains(e) && (hndl = new ObjectHandle<T>(e)).isValid()) {
            this.list.add(hndl);
            return true;
        }
        return false;
    }

    public void clear() {
        this.list.clear();
    }

    public int remove(T obj) {
        int numFound = 0;
        Iterator<ObjectHandle<T>> iter = this.list.iterator();
        while (iter.hasNext()) {
            ObjectHandle<T> hndl = iter.next();
            T currentObj = hndl.getObj();
            if (currentObj != null && currentObj != obj) continue;
            ++numFound;
            iter.remove();
        }
        return numFound;
    }

    public boolean contains(T obj) {
        if (!obj.exists()) {
            return false;
        }
        Iterator<ObjectHandle<T>> iter = this.list.iterator();
        while (iter.hasNext()) {
            ObjectHandle<T> hndl = iter.next();
            T currentObj = hndl.getObj();
            if (currentObj == null) {
                iter.remove();
                continue;
            }
            if (currentObj != obj) continue;
            return true;
        }
        return false;
    }

    public void validate() {
        Iterator<ObjectHandle<T>> iter = this.list.iterator();
        while (iter.hasNext()) {
            ObjectHandle<T> hndl = iter.next();
            if (!hndl.isInvalid()) continue;
            iter.remove();
        }
    }

    @Override
    public void initLoad(ObjectHandleResolver resolver) {
        for (ObjectHandle<T> handle : this.list) {
            handle.initLoad(resolver);
        }
        this.validate();
    }

    public void deleteAll() {
        ArrayList<ObjectHandle<T>> temp = new ArrayList<ObjectHandle<T>>(this.list);
        this.list.clear();
        for (ObjectHandle objectHandle : temp) {
            Object e = objectHandle.getObj();
            if (e == null || !e.exists()) continue;
            e.delete();
        }
    }

    public void deleteWhere(Predicate<T> deleteObj) {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            Handleable obj = (Handleable)iterator.next();
            if (!deleteObj.test(obj)) continue;
            iterator.remove();
            obj.delete();
        }
    }

    public void load(String idList) {
        this.load(Arrays.stream(Misc.splitNoempty(idList, ",")).mapToInt(Misc::getAsInt));
    }

    public void load(int[] idList) {
        this.load(IntStream.of(idList));
    }

    public void load(IntStream idList) {
        this.load(idList.iterator());
    }

    public void load(Iterator<Integer> idList) {
        while (idList.hasNext()) {
            int id = idList.next();
            if (id == -1) continue;
            ObjectHandle hndl = new ObjectHandle();
            hndl.load(id);
            this.list.add(hndl);
        }
    }

    public String save() {
        return this.stream().map(x -> "" + x.getSaveID()).collect(Collectors.joining(","));
    }

    public Stream<T> stream() {
        this.validate();
        return this.list.stream().map(ObjectHandle::getObj).filter(Objects::nonNull);
    }

    @Override
    public Iterator<T> iterator() {
        return new SkippingIterator<T>(){
            final Iterator<ObjectHandle<T>> iter;
            {
                this.iter = ObjectList.this.list.iterator();
            }

            @Override
            protected T findNextElement() {
                while (this.iter.hasNext()) {
                    ObjectHandle hndl = this.iter.next();
                    Object obj = hndl.getObj();
                    if (obj == null) {
                        this.iter.remove();
                        continue;
                    }
                    return obj;
                }
                this.onEndReached();
                return null;
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    public int size() {
        this.validate();
        return this.list.size();
    }

    public boolean isEmpty() {
        this.validate();
        return this.list.isEmpty();
    }

    public void toList(Collection<T> insert) {
        for (ObjectHandle<T> hndl : this.list) {
            T obj = hndl.getObj();
            if (obj == null) continue;
            insert.add(obj);
        }
    }

    public ArrayList<T> toList() {
        ArrayList<T> insert = new ArrayList<T>();
        for (ObjectHandle<T> hndl : this.list) {
            T obj = hndl.getObj();
            if (obj == null) continue;
            insert.add(obj);
        }
        return insert;
    }

    public void removeIf(Predicate<T> predicate) {
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            if (!predicate.test((Handleable)iter.next())) continue;
            iter.remove();
        }
    }
}

