/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.game;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.game.Handleable;
import com.iosoft.helpers.game.ObjectHandleResolver;
import com.iosoft.helpers.game.Resolvable;
import java.lang.ref.WeakReference;

public final class ObjectHandle<T extends Handleable>
implements Resolvable {
    public static final int ID_NULL = -1;
    private WeakReference<T> _ref;
    private int _objID = -1;

    public ObjectHandle() {
    }

    public ObjectHandle(T obj) {
        this.setObj(obj);
    }

    public T getObj() {
        if (this._ref == null) {
            return null;
        }
        Handleable o = (Handleable)this._ref.get();
        if (o == null || !o.exists()) {
            this._ref = null;
            return null;
        }
        return (T)o;
    }

    public void setObj(T e) {
        this._ref = e == null || !e.exists() ? null : new WeakReference<T>(e);
    }

    public void delete() {
        T obj = this.getObj();
        this.clear();
        if (obj != null) {
            obj.delete();
        }
    }

    public void validate() {
        if (this._ref == null) {
            return;
        }
        Handleable o = (Handleable)this._ref.get();
        if (o == null || !o.exists()) {
            this._ref = null;
        }
    }

    @Override
    public void initLoad(ObjectHandleResolver resolver) {
        this.initLoad(resolver, null);
    }

    public void initLoad(ObjectHandleResolver resolver, Class<T> clazz) {
        if (this._objID == -1) {
            return;
        }
        int id = this._objID;
        this._objID = -1;
        Handleable obj = resolver.tryFindObject(id);
        if (obj == null) {
            Log.Developer.warning("Object '" + id + "' not found while loading");
        } else if (clazz != null && !clazz.isInstance(obj)) {
            Log.Developer.warning("Object '" + id + "' has wrong class, expected '" + clazz.getSimpleName() + "', but got '" + Misc.getClassName(obj) + "'");
            obj = null;
        }
        this.setObj(obj);
    }

    public boolean isValid() {
        return this.getObj() != null;
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    public void clear() {
        this._ref = null;
    }

    public void load(int id) {
        this._objID = id;
    }

    public int save() {
        T o = this.getObj();
        return o == null ? -1 : o.getSaveID();
    }
}

