/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.game;

import com.iosoft.helpers.game.IDirection;
import com.iosoft.helpers.game.RandomIterator;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.math.Misc2D;
import com.iosoft.helpers.math.Vector2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public enum Direction implements IDirection
{
    LeftTop(-1, -1, -1),
    Top(0, -1, 3),
    RightTop(1, -1, -1),
    Right(1, 0, 0),
    RightBottom(1, 1, -1),
    Bottom(0, 1, 1),
    LeftBottom(-1, 1, -1),
    Left(-1, 0, 2);

    public final int ToX;
    public final int ToY;
    public final double Angle;
    public final Double CostBoxed;
    public final int CardinalIndex;
    public static final Direction[] ValuesAll;
    public static final Direction[] ValuesCardinal;
    public static final Direction[] ValuesCardinalFirst;
    public static final Iterable<Direction> RandomOrderAll;
    public static final Iterable<Direction> RandomOrderCardinal;

    static {
        ValuesAll = Direction.values();
        ValuesCardinal = new Direction[]{Right, Bottom, Left, Top};
        ValuesCardinalFirst = new Direction[]{Right, Bottom, Left, Top, LeftTop, RightTop, LeftBottom, RightBottom};
        RandomOrderAll = () -> new RandomIterator<Direction>(ValuesAll);
        RandomOrderCardinal = () -> new RandomIterator<Direction>(ValuesCardinal);
    }

    private Direction(int toX, int toY, int cardinalIndex) {
        this.ToX = toX;
        this.ToY = toY;
        this.CardinalIndex = cardinalIndex;
        this.Angle = Math.atan2(this.ToY, this.ToX);
        this.CostBoxed = this.getSimpleCost();
    }

    @Override
    public void moveSelf(Point p) {
        p.x += this.ToX;
        p.y += this.ToY;
    }

    public Direction opposite() {
        return ValuesAll[(this.ordinal() + 4) % 8];
    }

    public boolean isCardinal() {
        return this.CardinalIndex != -1;
    }

    public boolean isDiagonal() {
        return this.CardinalIndex == -1;
    }

    public double getSimpleCost() {
        return this.isDiagonal() ? Vector2D.HeuristicSqrt2 : 1.0;
    }

    public static Direction read(DataInputStream in) throws IOException {
        return MiscIO.readByte(in, ValuesAll);
    }

    public void write(DataOutputStream out) throws IOException {
        MiscIO.writeByte(out, this);
    }

    public static Direction readCardinal(DataInputStream in) throws IOException {
        int index = in.readUnsignedByte();
        if (index >= ValuesCardinal.length) {
            throw new IOException("Invalid value for cardinal direction (" + index + ")");
        }
        return ValuesCardinal[index];
    }

    public static Direction tryFromEvent(KeyEvent e) {
        return Direction.tryFromKeycode(e.getKeyCode());
    }

    public static Direction tryFromKeycode(int keyCode) {
        switch (keyCode) {
            case 38: 
            case 104: {
                return Top;
            }
            case 40: 
            case 98: {
                return Bottom;
            }
            case 37: 
            case 100: {
                return Left;
            }
            case 39: 
            case 102: {
                return Right;
            }
            case 36: 
            case 103: {
                return LeftTop;
            }
            case 33: 
            case 105: {
                return RightTop;
            }
            case 35: 
            case 97: {
                return LeftBottom;
            }
            case 34: 
            case 99: {
                return RightBottom;
            }
        }
        return null;
    }

    public static Direction closestFromAngle(double angle) {
        Direction[] directionArray = ValuesAll;
        int n = ValuesAll.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (Misc2D.getAngle(angle, direction.Angle) < 0.7853981633974483) {
                return direction;
            }
            ++n2;
        }
        return Top;
    }
}

