/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.datasource;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.datasource.AbstractDataSource;
import com.iosoft.helpers.datasource.RecursiveSubableDataSource;
import com.iosoft.helpers.io.MiscIO;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Resource
extends AbstractDataSource
implements RecursiveSubableDataSource<Resource> {
    private final String _resourcePath;

    public Resource(String resourcePath) {
        this._resourcePath = Misc.notNull(resourcePath);
    }

    public String getResourcePath() {
        return this._resourcePath;
    }

    @Override
    protected byte[] read() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream in = this.openInputStream();){
            return MiscIO.readFully(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected InputStream openInputStream() throws FileNotFoundException {
        return MiscIO.getResource(this._resourcePath);
    }

    @Override
    public InputStream tryOpenBufferedStream() {
        InputStream in = this.tryGetBufferStream();
        if (in != null) {
            return in;
        }
        in = Resource.class.getResourceAsStream(this._resourcePath);
        if (in == null) {
            return null;
        }
        return new BufferedInputStream(in);
    }

    @Override
    public Resource getSub(String subName) {
        return new Resource(String.valueOf(this._resourcePath) + subName);
    }

    public String toString() {
        return this._resourcePath;
    }

    @Override
    public boolean exists() {
        return MiscIO.resourceExists(this._resourcePath);
    }

    @Override
    public boolean doesExistsOpenTheStream() {
        return true;
    }
}

