/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.datasource;

import com.iosoft.helpers.FailableResult;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.Task;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public interface IDataSource {
    public Task<IOException> preloadAsync();

    public void preload() throws IOException;

    public byte[] load(boolean var1) throws IOException;

    default public byte[] load() throws IOException {
        return this.load(false);
    }

    public Task<FailableResult<byte[], IOException>> loadAsync(boolean var1);

    public void unload();

    public InputStream openBufferedStream() throws FileNotFoundException;

    public InputStream openBufferedStream(int var1) throws FileNotFoundException;

    public InputStream tryOpenBufferedStream();

    public boolean exists();

    public boolean doesExistsOpenTheStream();

    public static boolean exists_testOpen(IDataSource source) {
        try {
            InputStream in = source.openBufferedStream();
            Misc.forceClose(in);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }
}

