/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.datasource;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.datasource.AbstractDataSource;
import com.iosoft.helpers.datasource.RecursiveSubableDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;

public class FileSource
extends AbstractDataSource
implements RecursiveSubableDataSource<FileSource> {
    private final File _file;

    public FileSource(File file) {
        this._file = Misc.notNull(file);
    }

    public File getFile() {
        return this._file;
    }

    @Override
    protected byte[] read() throws IOException {
        return Files.readAllBytes(this._file.toPath());
    }

    @Override
    public InputStream openInputStream() throws FileNotFoundException {
        return new FileInputStream(this._file);
    }

    @Override
    public FileSource getSub(String subName) {
        return new FileSource(new File(this._file, subName));
    }

    public String toString() {
        return this._file.getPath();
    }

    @Override
    public boolean exists() {
        return this._file.exists();
    }

    @Override
    public boolean doesExistsOpenTheStream() {
        return false;
    }
}

