/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.datasource;

import com.iosoft.helpers.datasource.IDataSource;
import com.iosoft.helpers.io.MiscIO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public final class DataSourceUtil {
    private DataSourceUtil() {
    }

    public static String loadAsString(IDataSource dataSource) throws IOException {
        return DataSourceUtil.loadAsString(dataSource, StandardCharsets.UTF_8);
    }

    public static String loadAsString(IDataSource dataSource, Charset charset) throws IOException {
        return new String(dataSource.load(), charset);
    }

    public static ArrayList<String> loadAsStrings(IDataSource source) throws IOException {
        return DataSourceUtil.loadAsStrings(source, StandardCharsets.UTF_8);
    }

    public static ArrayList<String> loadAsStrings(IDataSource source, Charset charset) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = source.openBufferedStream();){
            return MiscIO.getStreamAsStrings(in, charset);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

