/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.console;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.console.ConsoleMultiplexer;
import com.iosoft.helpers.console.IConsoleListener;
import com.iosoft.helpers.event.Event;
import com.iosoft.helpers.event.EventSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PrefixConsoleMultiplexer
implements IDisposable,
ConsoleMultiplexer.IConsoleRegistrar {
    private final Map<String, IConsoleListener> _subConsoles = new HashMap<String, IConsoleListener>();
    private final ConsoleMultiplexer _consoleMultiplexer;
    private final Function<IConsoleListener, String> _determinePrefix;
    private final EventSource _allDisconnected = new EventSource();
    public final Event AllDisconnected;

    public PrefixConsoleMultiplexer(Function<IConsoleListener, String> determinePrefix) {
        this.AllDisconnected = (Event)this._allDisconnected.Event;
        this._determinePrefix = Misc.notNull(determinePrefix);
        this._consoleMultiplexer = new ConsoleMultiplexer(this);
        this._consoleMultiplexer.LineRead.register((String)((Object)((Consumer<String>)this::onInput)));
        this._consoleMultiplexer.Error.register(null);
    }

    @Override
    public void onConsoleConnect(IConsoleListener subConsole) {
        String prefix = this._determinePrefix.apply(subConsole);
        if (prefix == null) {
            subConsole.disconnect(new IOException("Multiplexer rejected console registration"));
            return;
        }
        this.add(prefix, subConsole);
    }

    @Override
    public void onConsoleDisconnect(IConsoleListener subConsole) {
        String key = this._subConsoles.entrySet().stream().filter(x -> x.getValue() == subConsole).map(Map.Entry::getKey).findAny().orElse(null);
        if (key != null) {
            this._subConsoles.remove(key);
        }
        if (this._subConsoles.isEmpty()) {
            this._allDisconnected.fire();
        }
    }

    public void add(String prefix, IConsoleListener listener) {
        Misc.notNull(prefix);
        Misc.notNull(listener);
        if (this._subConsoles.containsKey(prefix)) {
            throw new IllegalArgumentException("Prefix '" + prefix + "' is already assigned");
        }
        this._subConsoles.put(prefix, listener);
    }

    private void onInput(String input) {
        if (input.startsWith("all ")) {
            input = input.substring("all ".length());
            IConsoleListener[] iConsoleListenerArray = this._subConsoles.values().toArray(new IConsoleListener[this._subConsoles.size()]);
            int n = iConsoleListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConsoleListener listener = iConsoleListenerArray[n2];
                listener.writeLine(input);
                ++n2;
            }
            return;
        }
        for (Map.Entry<String, IConsoleListener> entry : this._subConsoles.entrySet()) {
            if (!PrefixConsoleMultiplexer.tryPrefix(entry, input, " ") && !PrefixConsoleMultiplexer.tryPrefix(entry, input, ": ") && !PrefixConsoleMultiplexer.tryPrefix(entry, input, ":")) continue;
            return;
        }
        System.out.println("Target console not specified (ID+space at the start (\"0 xxx\") or \"all xxx\" to send to all). Choose one:");
        System.out.println("all" + this._subConsoles.keySet().stream().map(x -> ", " + x).collect(Collectors.joining()));
    }

    private static boolean tryPrefix(Map.Entry<String, IConsoleListener> entry, String input, String prefix) {
        String starter = String.valueOf(entry.getKey()) + prefix;
        if (!input.startsWith(starter)) {
            return false;
        }
        input = input.substring(starter.length());
        entry.getValue().writeLine(input);
        return true;
    }

    public int getNumConnectedConsoles() {
        return this._subConsoles.size();
    }

    private void disconnect(IOException e) {
        this._consoleMultiplexer.dispose();
        for (IConsoleListener listeners : this._subConsoles.values()) {
            listeners.disconnect(e);
        }
        this._subConsoles.clear();
    }

    @Override
    public void dispose() {
        this.disconnect(new IOException("Console Multiplexer disposed"));
    }
}

