/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.console;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.MutableBool;
import com.iosoft.helpers.async.SubProcess;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.TaskSource;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.async.dispatcher.DispatcherKeepAliveToken;
import com.iosoft.helpers.console.ConsoleMultiplexer;
import com.iosoft.helpers.console.IConsoleListener;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ConsoleReader
extends SubProcess {
    public static final int PollReadyIntervalMillis = 200;

    public ConsoleReader(Predicate<String> handler, Consumer<IOException> onEnd) {
        this.start("Console Reader", () -> {
            try {
                String line;
                boolean shouldContinue;
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                do {
                    if (Thread.interrupted()) {
                        return;
                    }
                    while (true) {
                        if (br.ready()) {
                            if (!Thread.interrupted()) break;
                            return;
                        }
                        if (Thread.interrupted()) {
                            return;
                        }
                        Thread.sleep(200L);
                    }
                    line = br.readLine();
                    if (Thread.interrupted()) {
                        return;
                    }
                    if (line != null) continue;
                    throw new EOFException();
                } while (shouldContinue = this._dispatcher.dispatchCreateGetWaiter(() -> this.isRunning() && handler.test(line) && this.isRunning()).waitBlockingInterruptible().booleanValue());
                return;
            }
            catch (InterruptedException br) {
                return;
            }
            catch (IOException e) {
                this.post(() -> {
                    this.end();
                    onEnd.accept(e);
                });
            }
        });
    }

    public static Task<IOException> readAsync(final Consumer<String> handler) {
        DispatcherKeepAliveToken _token;
        TaskSource taskSource = new TaskSource();
        final Object _lock = new Object();
        final MutableBool _isLive = new MutableBool(true);
        final Dispatcher _dispatcher = Dispatcher.getForCurrentThread();
        IConsoleListener consoleListener = new IConsoleListener(_token = _dispatcher.createKeepAliveToken(), taskSource){
            private final /* synthetic */ DispatcherKeepAliveToken val$_token;
            private final /* synthetic */ TaskSource val$taskSource;
            {
                this.val$_token = dispatcherKeepAliveToken;
                this.val$taskSource = taskSource;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeLine(String line) {
                Object object = _lock;
                synchronized (object) {
                    if (!_isLive.Value) {
                        return;
                    }
                }
                _dispatcher.dispatch(() -> {
                    Object object2 = _lock;
                    synchronized (object2) {
                        if (!mutableBool.Value) {
                            return;
                        }
                    }
                    handler.accept(line);
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnect(IOException exception) {
                Object object = _lock;
                synchronized (object) {
                    if (!_isLive.Value) {
                        return;
                    }
                }
                _dispatcher.dispatch(() -> {
                    Object object2 = _lock;
                    synchronized (object2) {
                        if (!mutableBool.Value) {
                            return;
                        }
                        mutableBool.Value = false;
                    }
                    this.val$_token.dispose();
                    this.val$taskSource.setResult(exception);
                });
            }
        };
        Task<IDisposable> task = ConsoleMultiplexer.tryConnectToGlobalMultiplexerAsync(consoleListener);
        if (task == null) {
            _token.dispose();
            ConsoleReader consoleReader = new ConsoleReader(x -> {
                handler.accept((String)x);
                return true;
            }, taskSource::setResult);
            taskSource.CancelHandler = consoleReader::end;
        } else {
            MutableBool disconnectImmediately = new MutableBool(false);
            taskSource.CancelHandler = () -> {
                boolean bl = mutableBool.Value = true;
            };
            task.await((IDisposable)((Object)((Consumer<IDisposable>)killConnection -> {
                Runnable disconnect = () -> {
                    Object object2 = _lock;
                    synchronized (object2) {
                        mutableBool.Value = false;
                    }
                    killConnection.dispose();
                    _token.dispose();
                };
                if (mutableBool2.Value) {
                    disconnect.run();
                } else {
                    taskSource.CancelHandler = disconnect;
                }
            })));
        }
        return (Task)taskSource.getTask();
    }
}

