/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.binding;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.binding.Binding;
import com.iosoft.helpers.binding.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class Disposables
implements IDisposable {
    private List<IDisposable> disposables = new ArrayList<IDisposable>();

    public <T> void addDisposable(Observable<T> target, Consumer<T> action) {
        this.checkNotDisposed();
        this.addDisposable(new Binding<T>(target, action));
    }

    public <T extends IDisposable> T addDisposable(T disposable) {
        this.checkNotDisposed();
        this.disposables.add(disposable);
        return disposable;
    }

    private void checkNotDisposed() {
        if (this.disposables == null) {
            throw new IllegalStateException("Already disposed");
        }
    }

    @Override
    public void dispose() {
        if (this.disposables != null) {
            List<IDisposable> originalDisposables = this.disposables;
            this.disposables = null;
            for (IDisposable disposable : originalDisposables) {
                disposable.dispose();
            }
        }
    }
}

